package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link ReceivedOpenBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ReceivedOpenBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ReceivedOpenBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ReceivedOpenBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ReceivedOpenBuilder
 * @see Builder
 *
 */
public class ReceivedOpenBuilder implements Builder<ReceivedOpen> {

    private Ipv4AddressNoZone _bgpIdentifier;
    private List<BgpParameters> _bgpParameters;
    private Uint16 _holdTimer;
    private Uint16 _myAsNumber;
    private ProtocolVersion _version;


    Map<Class<? extends Augmentation<ReceivedOpen>>, Augmentation<ReceivedOpen>> augmentation = Collections.emptyMap();

    public ReceivedOpenBuilder() {
    }
    public ReceivedOpenBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.OpenMsg arg) {
        this._version = arg.getVersion();
        this._myAsNumber = arg.getMyAsNumber();
        this._holdTimer = arg.getHoldTimer();
        this._bgpIdentifier = arg.getBgpIdentifier();
        this._bgpParameters = arg.getBgpParameters();
    }
    public ReceivedOpenBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage arg) {
        this._version = arg.getVersion();
        this._myAsNumber = arg.getMyAsNumber();
        this._holdTimer = arg.getHoldTimer();
        this._bgpIdentifier = arg.getBgpIdentifier();
        this._bgpParameters = arg.getBgpParameters();
    }

    public ReceivedOpenBuilder(ReceivedOpen base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ReceivedOpen>>, Augmentation<ReceivedOpen>> aug =((AugmentationHolder<ReceivedOpen>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._bgpIdentifier = base.getBgpIdentifier();
        this._bgpParameters = base.getBgpParameters();
        this._holdTimer = base.getHoldTimer();
        this._myAsNumber = base.getMyAsNumber();
        this._version = base.getVersion();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.OpenMsg</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.OpenMsg) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage) {
            this._version = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage)arg).getVersion();
            this._myAsNumber = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage)arg).getMyAsNumber();
            this._holdTimer = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage)arg).getHoldTimer();
            this._bgpIdentifier = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage)arg).getBgpIdentifier();
            this._bgpParameters = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage)arg).getBgpParameters();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.OpenMsg, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage]");
    }

    public Ipv4AddressNoZone getBgpIdentifier() {
        return _bgpIdentifier;
    }
    
    public List<BgpParameters> getBgpParameters() {
        return _bgpParameters;
    }
    
    public Uint16 getHoldTimer() {
        return _holdTimer;
    }
    
    public Uint16 getMyAsNumber() {
        return _myAsNumber;
    }
    
    public ProtocolVersion getVersion() {
        return _version;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ReceivedOpen>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public ReceivedOpenBuilder setBgpIdentifier(final Ipv4AddressNoZone value) {
        this._bgpIdentifier = value;
        return this;
    }
    public ReceivedOpenBuilder setBgpParameters(final List<BgpParameters> values) {
        this._bgpParameters = values;
        return this;
    }
    
    
    public ReceivedOpenBuilder setHoldTimer(final Uint16 value) {
        this._holdTimer = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setHoldTimer(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public ReceivedOpenBuilder setHoldTimer(final Integer value) {
        return setHoldTimer(CodeHelpers.compatUint(value));
    }
    
    public ReceivedOpenBuilder setMyAsNumber(final Uint16 value) {
        this._myAsNumber = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setMyAsNumber(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public ReceivedOpenBuilder setMyAsNumber(final Integer value) {
        return setMyAsNumber(CodeHelpers.compatUint(value));
    }
    
    public ReceivedOpenBuilder setVersion(final ProtocolVersion value) {
        this._version = value;
        return this;
    }
    
    public ReceivedOpenBuilder addAugmentation(Class<? extends Augmentation<ReceivedOpen>> augmentationType, Augmentation<ReceivedOpen> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ReceivedOpenBuilder removeAugmentation(Class<? extends Augmentation<ReceivedOpen>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ReceivedOpen build() {
        return new ReceivedOpenImpl(this);
    }

    private static final class ReceivedOpenImpl
        extends AbstractAugmentable<ReceivedOpen>
        implements ReceivedOpen {
    
        private final Ipv4AddressNoZone _bgpIdentifier;
        private final List<BgpParameters> _bgpParameters;
        private final Uint16 _holdTimer;
        private final Uint16 _myAsNumber;
        private final ProtocolVersion _version;
    
        ReceivedOpenImpl(ReceivedOpenBuilder base) {
            super(base.augmentation);
            this._bgpIdentifier = base.getBgpIdentifier();
            this._bgpParameters = base.getBgpParameters();
            this._holdTimer = base.getHoldTimer();
            this._myAsNumber = base.getMyAsNumber();
            this._version = base.getVersion();
        }
    
        @Override
        public Ipv4AddressNoZone getBgpIdentifier() {
            return _bgpIdentifier;
        }
        
        @Override
        public List<BgpParameters> getBgpParameters() {
            return _bgpParameters;
        }
        
        @Override
        public Uint16 getHoldTimer() {
            return _holdTimer;
        }
        
        @Override
        public Uint16 getMyAsNumber() {
            return _myAsNumber;
        }
        
        @Override
        public ProtocolVersion getVersion() {
            return _version;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_bgpIdentifier);
            result = prime * result + Objects.hashCode(_bgpParameters);
            result = prime * result + Objects.hashCode(_holdTimer);
            result = prime * result + Objects.hashCode(_myAsNumber);
            result = prime * result + Objects.hashCode(_version);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ReceivedOpen.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            ReceivedOpen other = (ReceivedOpen)obj;
            if (!Objects.equals(_bgpIdentifier, other.getBgpIdentifier())) {
                return false;
            }
            if (!Objects.equals(_bgpParameters, other.getBgpParameters())) {
                return false;
            }
            if (!Objects.equals(_holdTimer, other.getHoldTimer())) {
                return false;
            }
            if (!Objects.equals(_myAsNumber, other.getMyAsNumber())) {
                return false;
            }
            if (!Objects.equals(_version, other.getVersion())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ReceivedOpenImpl otherImpl = (ReceivedOpenImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ReceivedOpen>>, Augmentation<ReceivedOpen>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ReceivedOpen");
            CodeHelpers.appendValue(helper, "_bgpIdentifier", _bgpIdentifier);
            CodeHelpers.appendValue(helper, "_bgpParameters", _bgpParameters);
            CodeHelpers.appendValue(helper, "_holdTimer", _holdTimer);
            CodeHelpers.appendValue(helper, "_myAsNumber", _myAsNumber);
            CodeHelpers.appendValue(helper, "_version", _version);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
