package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.OpenMsg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUp;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The full OPEN message transmitted by the monitored router to its peer.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container sent-open {
 *   uses open-msg;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-up/sent-open</i>
 *
 * <p>To create instances of this class use {@link SentOpenBuilder}.
 * @see SentOpenBuilder
 *
 */
public interface SentOpen
    extends
    ChildOf<PeerUp>,
    Augmentable<SentOpen>,
    OpenMsg
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("sent-open");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpen> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpen.class;
    }

}

