package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.AdjRibsInRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicatePrefixAdvertisementsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateUpdatesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateWithdrawsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsConfedLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsPathLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedClusterListLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedOriginatorIdTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.LocRibRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiLocRibTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PrefixesTreatedAsWithdrawTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.RejectedPrefixesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.UpdatesTreatedAsWithdrawTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TlvsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TlvsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TlvsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TlvsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TlvsBuilder
 * @see Builder
 *
 */
public class TlvsBuilder implements Builder<Tlvs> {

    private AdjRibsInRoutesTlv _adjRibsInRoutesTlv;
    private DuplicatePrefixAdvertisementsTlv _duplicatePrefixAdvertisementsTlv;
    private DuplicateUpdatesTlv _duplicateUpdatesTlv;
    private DuplicateWithdrawsTlv _duplicateWithdrawsTlv;
    private InvalidatedAsConfedLoopTlv _invalidatedAsConfedLoopTlv;
    private InvalidatedAsPathLoopTlv _invalidatedAsPathLoopTlv;
    private InvalidatedClusterListLoopTlv _invalidatedClusterListLoopTlv;
    private InvalidatedOriginatorIdTlv _invalidatedOriginatorIdTlv;
    private LocRibRoutesTlv _locRibRoutesTlv;
    private PerAfiSafiAdjRibInTlv _perAfiSafiAdjRibInTlv;
    private PerAfiSafiLocRibTlv _perAfiSafiLocRibTlv;
    private PrefixesTreatedAsWithdrawTlv _prefixesTreatedAsWithdrawTlv;
    private RejectedPrefixesTlv _rejectedPrefixesTlv;
    private UpdatesTreatedAsWithdrawTlv _updatesTreatedAsWithdrawTlv;


    Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Collections.emptyMap();

    public TlvsBuilder() {
    }
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs arg) {
        this._rejectedPrefixesTlv = arg.getRejectedPrefixesTlv();
        this._duplicatePrefixAdvertisementsTlv = arg.getDuplicatePrefixAdvertisementsTlv();
        this._duplicateWithdrawsTlv = arg.getDuplicateWithdrawsTlv();
        this._invalidatedClusterListLoopTlv = arg.getInvalidatedClusterListLoopTlv();
        this._invalidatedAsPathLoopTlv = arg.getInvalidatedAsPathLoopTlv();
        this._invalidatedOriginatorIdTlv = arg.getInvalidatedOriginatorIdTlv();
        this._invalidatedAsConfedLoopTlv = arg.getInvalidatedAsConfedLoopTlv();
        this._adjRibsInRoutesTlv = arg.getAdjRibsInRoutesTlv();
        this._locRibRoutesTlv = arg.getLocRibRoutesTlv();
        this._perAfiSafiAdjRibInTlv = arg.getPerAfiSafiAdjRibInTlv();
        this._perAfiSafiLocRibTlv = arg.getPerAfiSafiLocRibTlv();
        this._updatesTreatedAsWithdrawTlv = arg.getUpdatesTreatedAsWithdrawTlv();
        this._prefixesTreatedAsWithdrawTlv = arg.getPrefixesTreatedAsWithdrawTlv();
        this._duplicateUpdatesTlv = arg.getDuplicateUpdatesTlv();
    }

    public TlvsBuilder(Tlvs base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> aug =((AugmentationHolder<Tlvs>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._adjRibsInRoutesTlv = base.getAdjRibsInRoutesTlv();
        this._duplicatePrefixAdvertisementsTlv = base.getDuplicatePrefixAdvertisementsTlv();
        this._duplicateUpdatesTlv = base.getDuplicateUpdatesTlv();
        this._duplicateWithdrawsTlv = base.getDuplicateWithdrawsTlv();
        this._invalidatedAsConfedLoopTlv = base.getInvalidatedAsConfedLoopTlv();
        this._invalidatedAsPathLoopTlv = base.getInvalidatedAsPathLoopTlv();
        this._invalidatedClusterListLoopTlv = base.getInvalidatedClusterListLoopTlv();
        this._invalidatedOriginatorIdTlv = base.getInvalidatedOriginatorIdTlv();
        this._locRibRoutesTlv = base.getLocRibRoutesTlv();
        this._perAfiSafiAdjRibInTlv = base.getPerAfiSafiAdjRibInTlv();
        this._perAfiSafiLocRibTlv = base.getPerAfiSafiLocRibTlv();
        this._prefixesTreatedAsWithdrawTlv = base.getPrefixesTreatedAsWithdrawTlv();
        this._rejectedPrefixesTlv = base.getRejectedPrefixesTlv();
        this._updatesTreatedAsWithdrawTlv = base.getUpdatesTreatedAsWithdrawTlv();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs) {
            this._rejectedPrefixesTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getRejectedPrefixesTlv();
            this._duplicatePrefixAdvertisementsTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getDuplicatePrefixAdvertisementsTlv();
            this._duplicateWithdrawsTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getDuplicateWithdrawsTlv();
            this._invalidatedClusterListLoopTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getInvalidatedClusterListLoopTlv();
            this._invalidatedAsPathLoopTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getInvalidatedAsPathLoopTlv();
            this._invalidatedOriginatorIdTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getInvalidatedOriginatorIdTlv();
            this._invalidatedAsConfedLoopTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getInvalidatedAsConfedLoopTlv();
            this._adjRibsInRoutesTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getAdjRibsInRoutesTlv();
            this._locRibRoutesTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getLocRibRoutesTlv();
            this._perAfiSafiAdjRibInTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getPerAfiSafiAdjRibInTlv();
            this._perAfiSafiLocRibTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getPerAfiSafiLocRibTlv();
            this._updatesTreatedAsWithdrawTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getUpdatesTreatedAsWithdrawTlv();
            this._prefixesTreatedAsWithdrawTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getPrefixesTreatedAsWithdrawTlv();
            this._duplicateUpdatesTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs)arg).getDuplicateUpdatesTlv();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs]");
    }

    public AdjRibsInRoutesTlv getAdjRibsInRoutesTlv() {
        return _adjRibsInRoutesTlv;
    }
    
    public DuplicatePrefixAdvertisementsTlv getDuplicatePrefixAdvertisementsTlv() {
        return _duplicatePrefixAdvertisementsTlv;
    }
    
    public DuplicateUpdatesTlv getDuplicateUpdatesTlv() {
        return _duplicateUpdatesTlv;
    }
    
    public DuplicateWithdrawsTlv getDuplicateWithdrawsTlv() {
        return _duplicateWithdrawsTlv;
    }
    
    public InvalidatedAsConfedLoopTlv getInvalidatedAsConfedLoopTlv() {
        return _invalidatedAsConfedLoopTlv;
    }
    
    public InvalidatedAsPathLoopTlv getInvalidatedAsPathLoopTlv() {
        return _invalidatedAsPathLoopTlv;
    }
    
    public InvalidatedClusterListLoopTlv getInvalidatedClusterListLoopTlv() {
        return _invalidatedClusterListLoopTlv;
    }
    
    public InvalidatedOriginatorIdTlv getInvalidatedOriginatorIdTlv() {
        return _invalidatedOriginatorIdTlv;
    }
    
    public LocRibRoutesTlv getLocRibRoutesTlv() {
        return _locRibRoutesTlv;
    }
    
    public PerAfiSafiAdjRibInTlv getPerAfiSafiAdjRibInTlv() {
        return _perAfiSafiAdjRibInTlv;
    }
    
    public PerAfiSafiLocRibTlv getPerAfiSafiLocRibTlv() {
        return _perAfiSafiLocRibTlv;
    }
    
    public PrefixesTreatedAsWithdrawTlv getPrefixesTreatedAsWithdrawTlv() {
        return _prefixesTreatedAsWithdrawTlv;
    }
    
    public RejectedPrefixesTlv getRejectedPrefixesTlv() {
        return _rejectedPrefixesTlv;
    }
    
    public UpdatesTreatedAsWithdrawTlv getUpdatesTreatedAsWithdrawTlv() {
        return _updatesTreatedAsWithdrawTlv;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Tlvs>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public TlvsBuilder setAdjRibsInRoutesTlv(final AdjRibsInRoutesTlv value) {
        this._adjRibsInRoutesTlv = value;
        return this;
    }
    
    public TlvsBuilder setDuplicatePrefixAdvertisementsTlv(final DuplicatePrefixAdvertisementsTlv value) {
        this._duplicatePrefixAdvertisementsTlv = value;
        return this;
    }
    
    public TlvsBuilder setDuplicateUpdatesTlv(final DuplicateUpdatesTlv value) {
        this._duplicateUpdatesTlv = value;
        return this;
    }
    
    public TlvsBuilder setDuplicateWithdrawsTlv(final DuplicateWithdrawsTlv value) {
        this._duplicateWithdrawsTlv = value;
        return this;
    }
    
    public TlvsBuilder setInvalidatedAsConfedLoopTlv(final InvalidatedAsConfedLoopTlv value) {
        this._invalidatedAsConfedLoopTlv = value;
        return this;
    }
    
    public TlvsBuilder setInvalidatedAsPathLoopTlv(final InvalidatedAsPathLoopTlv value) {
        this._invalidatedAsPathLoopTlv = value;
        return this;
    }
    
    public TlvsBuilder setInvalidatedClusterListLoopTlv(final InvalidatedClusterListLoopTlv value) {
        this._invalidatedClusterListLoopTlv = value;
        return this;
    }
    
    public TlvsBuilder setInvalidatedOriginatorIdTlv(final InvalidatedOriginatorIdTlv value) {
        this._invalidatedOriginatorIdTlv = value;
        return this;
    }
    
    public TlvsBuilder setLocRibRoutesTlv(final LocRibRoutesTlv value) {
        this._locRibRoutesTlv = value;
        return this;
    }
    
    public TlvsBuilder setPerAfiSafiAdjRibInTlv(final PerAfiSafiAdjRibInTlv value) {
        this._perAfiSafiAdjRibInTlv = value;
        return this;
    }
    
    public TlvsBuilder setPerAfiSafiLocRibTlv(final PerAfiSafiLocRibTlv value) {
        this._perAfiSafiLocRibTlv = value;
        return this;
    }
    
    public TlvsBuilder setPrefixesTreatedAsWithdrawTlv(final PrefixesTreatedAsWithdrawTlv value) {
        this._prefixesTreatedAsWithdrawTlv = value;
        return this;
    }
    
    public TlvsBuilder setRejectedPrefixesTlv(final RejectedPrefixesTlv value) {
        this._rejectedPrefixesTlv = value;
        return this;
    }
    
    public TlvsBuilder setUpdatesTreatedAsWithdrawTlv(final UpdatesTreatedAsWithdrawTlv value) {
        this._updatesTreatedAsWithdrawTlv = value;
        return this;
    }
    
    public TlvsBuilder addAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType, Augmentation<Tlvs> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public TlvsBuilder removeAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Tlvs build() {
        return new TlvsImpl(this);
    }

    private static final class TlvsImpl
        extends AbstractAugmentable<Tlvs>
        implements Tlvs {
    
        private final AdjRibsInRoutesTlv _adjRibsInRoutesTlv;
        private final DuplicatePrefixAdvertisementsTlv _duplicatePrefixAdvertisementsTlv;
        private final DuplicateUpdatesTlv _duplicateUpdatesTlv;
        private final DuplicateWithdrawsTlv _duplicateWithdrawsTlv;
        private final InvalidatedAsConfedLoopTlv _invalidatedAsConfedLoopTlv;
        private final InvalidatedAsPathLoopTlv _invalidatedAsPathLoopTlv;
        private final InvalidatedClusterListLoopTlv _invalidatedClusterListLoopTlv;
        private final InvalidatedOriginatorIdTlv _invalidatedOriginatorIdTlv;
        private final LocRibRoutesTlv _locRibRoutesTlv;
        private final PerAfiSafiAdjRibInTlv _perAfiSafiAdjRibInTlv;
        private final PerAfiSafiLocRibTlv _perAfiSafiLocRibTlv;
        private final PrefixesTreatedAsWithdrawTlv _prefixesTreatedAsWithdrawTlv;
        private final RejectedPrefixesTlv _rejectedPrefixesTlv;
        private final UpdatesTreatedAsWithdrawTlv _updatesTreatedAsWithdrawTlv;
    
        TlvsImpl(TlvsBuilder base) {
            super(base.augmentation);
            this._adjRibsInRoutesTlv = base.getAdjRibsInRoutesTlv();
            this._duplicatePrefixAdvertisementsTlv = base.getDuplicatePrefixAdvertisementsTlv();
            this._duplicateUpdatesTlv = base.getDuplicateUpdatesTlv();
            this._duplicateWithdrawsTlv = base.getDuplicateWithdrawsTlv();
            this._invalidatedAsConfedLoopTlv = base.getInvalidatedAsConfedLoopTlv();
            this._invalidatedAsPathLoopTlv = base.getInvalidatedAsPathLoopTlv();
            this._invalidatedClusterListLoopTlv = base.getInvalidatedClusterListLoopTlv();
            this._invalidatedOriginatorIdTlv = base.getInvalidatedOriginatorIdTlv();
            this._locRibRoutesTlv = base.getLocRibRoutesTlv();
            this._perAfiSafiAdjRibInTlv = base.getPerAfiSafiAdjRibInTlv();
            this._perAfiSafiLocRibTlv = base.getPerAfiSafiLocRibTlv();
            this._prefixesTreatedAsWithdrawTlv = base.getPrefixesTreatedAsWithdrawTlv();
            this._rejectedPrefixesTlv = base.getRejectedPrefixesTlv();
            this._updatesTreatedAsWithdrawTlv = base.getUpdatesTreatedAsWithdrawTlv();
        }
    
        @Override
        public AdjRibsInRoutesTlv getAdjRibsInRoutesTlv() {
            return _adjRibsInRoutesTlv;
        }
        
        @Override
        public DuplicatePrefixAdvertisementsTlv getDuplicatePrefixAdvertisementsTlv() {
            return _duplicatePrefixAdvertisementsTlv;
        }
        
        @Override
        public DuplicateUpdatesTlv getDuplicateUpdatesTlv() {
            return _duplicateUpdatesTlv;
        }
        
        @Override
        public DuplicateWithdrawsTlv getDuplicateWithdrawsTlv() {
            return _duplicateWithdrawsTlv;
        }
        
        @Override
        public InvalidatedAsConfedLoopTlv getInvalidatedAsConfedLoopTlv() {
            return _invalidatedAsConfedLoopTlv;
        }
        
        @Override
        public InvalidatedAsPathLoopTlv getInvalidatedAsPathLoopTlv() {
            return _invalidatedAsPathLoopTlv;
        }
        
        @Override
        public InvalidatedClusterListLoopTlv getInvalidatedClusterListLoopTlv() {
            return _invalidatedClusterListLoopTlv;
        }
        
        @Override
        public InvalidatedOriginatorIdTlv getInvalidatedOriginatorIdTlv() {
            return _invalidatedOriginatorIdTlv;
        }
        
        @Override
        public LocRibRoutesTlv getLocRibRoutesTlv() {
            return _locRibRoutesTlv;
        }
        
        @Override
        public PerAfiSafiAdjRibInTlv getPerAfiSafiAdjRibInTlv() {
            return _perAfiSafiAdjRibInTlv;
        }
        
        @Override
        public PerAfiSafiLocRibTlv getPerAfiSafiLocRibTlv() {
            return _perAfiSafiLocRibTlv;
        }
        
        @Override
        public PrefixesTreatedAsWithdrawTlv getPrefixesTreatedAsWithdrawTlv() {
            return _prefixesTreatedAsWithdrawTlv;
        }
        
        @Override
        public RejectedPrefixesTlv getRejectedPrefixesTlv() {
            return _rejectedPrefixesTlv;
        }
        
        @Override
        public UpdatesTreatedAsWithdrawTlv getUpdatesTreatedAsWithdrawTlv() {
            return _updatesTreatedAsWithdrawTlv;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_adjRibsInRoutesTlv);
            result = prime * result + Objects.hashCode(_duplicatePrefixAdvertisementsTlv);
            result = prime * result + Objects.hashCode(_duplicateUpdatesTlv);
            result = prime * result + Objects.hashCode(_duplicateWithdrawsTlv);
            result = prime * result + Objects.hashCode(_invalidatedAsConfedLoopTlv);
            result = prime * result + Objects.hashCode(_invalidatedAsPathLoopTlv);
            result = prime * result + Objects.hashCode(_invalidatedClusterListLoopTlv);
            result = prime * result + Objects.hashCode(_invalidatedOriginatorIdTlv);
            result = prime * result + Objects.hashCode(_locRibRoutesTlv);
            result = prime * result + Objects.hashCode(_perAfiSafiAdjRibInTlv);
            result = prime * result + Objects.hashCode(_perAfiSafiLocRibTlv);
            result = prime * result + Objects.hashCode(_prefixesTreatedAsWithdrawTlv);
            result = prime * result + Objects.hashCode(_rejectedPrefixesTlv);
            result = prime * result + Objects.hashCode(_updatesTreatedAsWithdrawTlv);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tlvs.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Tlvs other = (Tlvs)obj;
            if (!Objects.equals(_adjRibsInRoutesTlv, other.getAdjRibsInRoutesTlv())) {
                return false;
            }
            if (!Objects.equals(_duplicatePrefixAdvertisementsTlv, other.getDuplicatePrefixAdvertisementsTlv())) {
                return false;
            }
            if (!Objects.equals(_duplicateUpdatesTlv, other.getDuplicateUpdatesTlv())) {
                return false;
            }
            if (!Objects.equals(_duplicateWithdrawsTlv, other.getDuplicateWithdrawsTlv())) {
                return false;
            }
            if (!Objects.equals(_invalidatedAsConfedLoopTlv, other.getInvalidatedAsConfedLoopTlv())) {
                return false;
            }
            if (!Objects.equals(_invalidatedAsPathLoopTlv, other.getInvalidatedAsPathLoopTlv())) {
                return false;
            }
            if (!Objects.equals(_invalidatedClusterListLoopTlv, other.getInvalidatedClusterListLoopTlv())) {
                return false;
            }
            if (!Objects.equals(_invalidatedOriginatorIdTlv, other.getInvalidatedOriginatorIdTlv())) {
                return false;
            }
            if (!Objects.equals(_locRibRoutesTlv, other.getLocRibRoutesTlv())) {
                return false;
            }
            if (!Objects.equals(_perAfiSafiAdjRibInTlv, other.getPerAfiSafiAdjRibInTlv())) {
                return false;
            }
            if (!Objects.equals(_perAfiSafiLocRibTlv, other.getPerAfiSafiLocRibTlv())) {
                return false;
            }
            if (!Objects.equals(_prefixesTreatedAsWithdrawTlv, other.getPrefixesTreatedAsWithdrawTlv())) {
                return false;
            }
            if (!Objects.equals(_rejectedPrefixesTlv, other.getRejectedPrefixesTlv())) {
                return false;
            }
            if (!Objects.equals(_updatesTreatedAsWithdrawTlv, other.getUpdatesTreatedAsWithdrawTlv())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TlvsImpl otherImpl = (TlvsImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Tlvs");
            CodeHelpers.appendValue(helper, "_adjRibsInRoutesTlv", _adjRibsInRoutesTlv);
            CodeHelpers.appendValue(helper, "_duplicatePrefixAdvertisementsTlv", _duplicatePrefixAdvertisementsTlv);
            CodeHelpers.appendValue(helper, "_duplicateUpdatesTlv", _duplicateUpdatesTlv);
            CodeHelpers.appendValue(helper, "_duplicateWithdrawsTlv", _duplicateWithdrawsTlv);
            CodeHelpers.appendValue(helper, "_invalidatedAsConfedLoopTlv", _invalidatedAsConfedLoopTlv);
            CodeHelpers.appendValue(helper, "_invalidatedAsPathLoopTlv", _invalidatedAsPathLoopTlv);
            CodeHelpers.appendValue(helper, "_invalidatedClusterListLoopTlv", _invalidatedClusterListLoopTlv);
            CodeHelpers.appendValue(helper, "_invalidatedOriginatorIdTlv", _invalidatedOriginatorIdTlv);
            CodeHelpers.appendValue(helper, "_locRibRoutesTlv", _locRibRoutesTlv);
            CodeHelpers.appendValue(helper, "_perAfiSafiAdjRibInTlv", _perAfiSafiAdjRibInTlv);
            CodeHelpers.appendValue(helper, "_perAfiSafiLocRibTlv", _perAfiSafiLocRibTlv);
            CodeHelpers.appendValue(helper, "_prefixesTreatedAsWithdrawTlv", _prefixesTreatedAsWithdrawTlv);
            CodeHelpers.appendValue(helper, "_rejectedPrefixesTlv", _rejectedPrefixesTlv);
            CodeHelpers.appendValue(helper, "_updatesTreatedAsWithdrawTlv", _updatesTreatedAsWithdrawTlv);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
