package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link InvalidatedAsConfedLoopTlvBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     InvalidatedAsConfedLoopTlvBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new InvalidatedAsConfedLoopTlvBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of InvalidatedAsConfedLoopTlvBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see InvalidatedAsConfedLoopTlvBuilder
 * @see Builder
 *
 */
public class InvalidatedAsConfedLoopTlvBuilder implements Builder<InvalidatedAsConfedLoopTlv> {

    private Counter32 _count;


    Map<Class<? extends Augmentation<InvalidatedAsConfedLoopTlv>>, Augmentation<InvalidatedAsConfedLoopTlv>> augmentation = Collections.emptyMap();

    public InvalidatedAsConfedLoopTlvBuilder() {
    }
    public InvalidatedAsConfedLoopTlvBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.CountTlv arg) {
        this._count = arg.getCount();
    }
    public InvalidatedAsConfedLoopTlvBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv arg) {
    }

    public InvalidatedAsConfedLoopTlvBuilder(InvalidatedAsConfedLoopTlv base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<InvalidatedAsConfedLoopTlv>>, Augmentation<InvalidatedAsConfedLoopTlv>> aug =((AugmentationHolder<InvalidatedAsConfedLoopTlv>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._count = base.getCount();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.CountTlv</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.CountTlv) {
            this._count = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.CountTlv)arg).getCount();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.CountTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv]");
    }

    public Counter32 getCount() {
        return _count;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<InvalidatedAsConfedLoopTlv>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public InvalidatedAsConfedLoopTlvBuilder setCount(final Counter32 value) {
        this._count = value;
        return this;
    }
    
    public InvalidatedAsConfedLoopTlvBuilder addAugmentation(Class<? extends Augmentation<InvalidatedAsConfedLoopTlv>> augmentationType, Augmentation<InvalidatedAsConfedLoopTlv> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public InvalidatedAsConfedLoopTlvBuilder removeAugmentation(Class<? extends Augmentation<InvalidatedAsConfedLoopTlv>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public InvalidatedAsConfedLoopTlv build() {
        return new InvalidatedAsConfedLoopTlvImpl(this);
    }

    private static final class InvalidatedAsConfedLoopTlvImpl
        extends AbstractAugmentable<InvalidatedAsConfedLoopTlv>
        implements InvalidatedAsConfedLoopTlv {
    
        private final Counter32 _count;
    
        InvalidatedAsConfedLoopTlvImpl(InvalidatedAsConfedLoopTlvBuilder base) {
            super(base.augmentation);
            this._count = base.getCount();
        }
    
        @Override
        public Counter32 getCount() {
            return _count;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_count);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InvalidatedAsConfedLoopTlv.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            InvalidatedAsConfedLoopTlv other = (InvalidatedAsConfedLoopTlv)obj;
            if (!Objects.equals(_count, other.getCount())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                InvalidatedAsConfedLoopTlvImpl otherImpl = (InvalidatedAsConfedLoopTlvImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<InvalidatedAsConfedLoopTlv>>, Augmentation<InvalidatedAsConfedLoopTlv>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("InvalidatedAsConfedLoopTlv");
            CodeHelpers.appendValue(helper, "_count", _count);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
