package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.AfiSafiGaugeTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Stat Type = 9: Number of routes in per-AFI/SAFI Adj-RIB-In. The value is 
 * structured as: AFI (2 bytes), SAFI (1 byte), followed by a 64-bit Gauge.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container per-afi-safi-adj-rib-in-tlv {
 *   uses afi-safi-gauge-tlv;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/stat-tlvs/per-afi-safi-adj-rib-in-tlv</i>
 *
 * <p>To create instances of this class use {@link PerAfiSafiAdjRibInTlvBuilder}.
 * @see PerAfiSafiAdjRibInTlvBuilder
 *
 */
public interface PerAfiSafiAdjRibInTlv
    extends
    ChildOf<StatTlvs>,
    Augmentable<PerAfiSafiAdjRibInTlv>,
    AfiSafiGaugeTlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("per-afi-safi-adj-rib-in-tlv");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv.class;
    }

}

