package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.CountTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Stat Type = 12: (32-bit Counter) Number of prefixes subjected to 
 * treat-as-withdraw treatment. 
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container prefixes-treated-as-withdraw-tlv {
 *   uses count-tlv;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/stat-tlvs/prefixes-treated-as-withdraw-tlv</i>
 *
 * <p>To create instances of this class use {@link PrefixesTreatedAsWithdrawTlvBuilder}.
 * @see PrefixesTreatedAsWithdrawTlvBuilder
 *
 */
public interface PrefixesTreatedAsWithdrawTlv
    extends
    ChildOf<StatTlvs>,
    Augmentable<PrefixesTreatedAsWithdrawTlv>,
    CountTlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("prefixes-treated-as-withdraw-tlv");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PrefixesTreatedAsWithdrawTlv> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PrefixesTreatedAsWithdrawTlv.class;
    }

}

