package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Type = 0: String. The Information field contains a free-form UTF-8 string whose 
 * length is given by the Information Length field. Inclusion of this TLV is 
 * optional. Multiple String TLVs MAY be included in the message.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container string-tlv {
 *   uses tlv;
 *   leaf string-info {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/string-tlv/string-tlv</i>
 *
 * <p>To create instances of this class use {@link StringTlvBuilder}.
 * @see StringTlvBuilder
 *
 */
public interface StringTlv
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StringTlv>,
    Augmentable<StringTlv>,
    Tlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("string-tlv");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.tlv.StringTlv.class;
    }
    
    /**
     * @return <code>java.lang.String</code> <code>stringInfo</code>, or <code>null</code> if not present
     */
    @Nullable String getStringInfo();

}

