package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the base YANG definitions for BMP Monitor Configuration. 
 * Copyright (c) 2017 Pantheon Technologies s.r.o. and others. All rights 
 * This program and the accompanying materials are made available under the terms 
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-bmp-monitor-config</b>
 * <pre>
 * module odl-bmp-monitor-config {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:bmp-monitor-config;
 *   prefix bmp-monitor-config;
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import rfc2385 {
 *     prefix rfc2385;
 *     revision-date 2016-03-24;
 *   }
 *   import bmp-monitor {
 *     prefix bmp-monitor;
 *     revision-date 2020-01-20;
 *   }
 *   revision 2020-01-20 {
 *   }
 *   revision 2018-03-29 {
 *   }
 *   revision 2017-12-07 {
 *   }
 *   revision 2017-05-17 {
 *   }
 *   grouping server-config {
 *     container server {
 *       leaf binding-address {
 *         type inet:ip-address-no-zone;
 *         default 0.0.0.0;
 *       }
 *       leaf binding-port {
 *         type inet:port-number;
 *       }
 *     }
 *   }
 *   container odl-bmp-monitors {
 *     list bmp-monitor-config {
 *       key monitor-id;
 *       leaf monitor-id {
 *         type bmp-monitor:monitor-id;
 *       }
 *       uses server-config;
 *       list monitored-router {
 *         leaf address {
 *           type inet:ip-address-no-zone;
 *         }
 *         key address;
 *         leaf active {
 *           type boolean;
 *         }
 *         leaf port {
 *           when "../active = 'true'";
 *           type inet:port-number;
 *         }
 *         leaf password {
 *           type rfc2385:rfc2385-key;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface OdlBmpMonitorConfigData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors</code> <code>odlBmpMonitors</code>, or <code>null</code> if not present
     */
    @Nullable OdlBmpMonitors getOdlBmpMonitors();

}

