package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.BmpMonitorConfig;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-bmp-monitor-config</b>
 * <pre>
 * container odl-bmp-monitors {
 *   list bmp-monitor-config {
 *     key monitor-id;
 *     leaf monitor-id {
 *       type bmp-monitor:monitor-id;
 *     }
 *     uses server-config;
 *     list monitored-router {
 *       leaf address {
 *         type inet:ip-address-no-zone;
 *       }
 *       key address;
 *       leaf active {
 *         type boolean;
 *       }
 *       leaf port {
 *         when "../active = 'true'";
 *         type inet:port-number;
 *       }
 *       leaf password {
 *         type rfc2385:rfc2385-key;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-bmp-monitor-config/odl-bmp-monitors</i>
 *
 * <p>To create instances of this class use {@link OdlBmpMonitorsBuilder}.
 * @see OdlBmpMonitorsBuilder
 *
 */
public interface OdlBmpMonitors
    extends
    ChildOf<OdlBmpMonitorConfigData>,
    Augmentable<OdlBmpMonitors>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("odl-bmp-monitors");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors.class;
    }
    
    /**
     * @return <code>java.util.List</code> <code>bmpMonitorConfig</code>, or <code>null</code> if not present
     */
    @Nullable List<BmpMonitorConfig> getBmpMonitorConfig();
    
    /**
     * @return <code>java.util.List</code> <code>bmpMonitorConfig</code>, or an empty list if it is not present
     */
    default @NonNull List<BmpMonitorConfig> nonnullBmpMonitorConfig() {
        return CodeHelpers.nonnull(getBmpMonitorConfig());
    }

}

