package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.ServerConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-bmp-monitor-config</b>
 * <pre>
 * list bmp-monitor-config {
 *   key monitor-id;
 *   leaf monitor-id {
 *     type bmp-monitor:monitor-id;
 *   }
 *   uses server-config;
 *   list monitored-router {
 *     leaf address {
 *       type inet:ip-address-no-zone;
 *     }
 *     key address;
 *     leaf active {
 *       type boolean;
 *     }
 *     leaf port {
 *       when "../active = 'true'";
 *       type inet:port-number;
 *     }
 *     leaf password {
 *       type rfc2385:rfc2385-key;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-bmp-monitor-config/odl-bmp-monitors/bmp-monitor-config</i>
 *
 * <p>To create instances of this class use {@link BmpMonitorConfigBuilder}.
 * @see BmpMonitorConfigBuilder
 * @see BmpMonitorConfigKey
 *
 */
public interface BmpMonitorConfig
    extends
    ChildOf<OdlBmpMonitors>,
    Augmentable<BmpMonitorConfig>,
    ServerConfig,
    Identifiable<BmpMonitorConfigKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("bmp-monitor-config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.BmpMonitorConfig> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.BmpMonitorConfig.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId</code> <code>monitorId</code>, or <code>null</code> if not present
     */
    @Nullable MonitorId getMonitorId();
    
    /**
     * @return <code>java.util.List</code> <code>monitoredRouter</code>, or <code>null</code> if not present
     */
    @Nullable List<MonitoredRouter> getMonitoredRouter();
    
    /**
     * @return <code>java.util.List</code> <code>monitoredRouter</code>, or an empty list if it is not present
     */
    default @NonNull List<MonitoredRouter> nonnullMonitoredRouter() {
        return CodeHelpers.nonnull(getMonitoredRouter());
    }
    
    @Override
    BmpMonitorConfigKey key();

}

