package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.server.config.Server;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BmpMonitorConfigBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BmpMonitorConfigBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new BmpMonitorConfigBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BmpMonitorConfigBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BmpMonitorConfigBuilder
 * @see Builder
 *
 */
public class BmpMonitorConfigBuilder implements Builder<BmpMonitorConfig> {

    private MonitorId _monitorId;
    private List<MonitoredRouter> _monitoredRouter;
    private Server _server;
    private BmpMonitorConfigKey key;


    Map<Class<? extends Augmentation<BmpMonitorConfig>>, Augmentation<BmpMonitorConfig>> augmentation = Collections.emptyMap();

    public BmpMonitorConfigBuilder() {
    }
    public BmpMonitorConfigBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.ServerConfig arg) {
        this._server = arg.getServer();
    }

    public BmpMonitorConfigBuilder(BmpMonitorConfig base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<BmpMonitorConfig>>, Augmentation<BmpMonitorConfig>> aug =((AugmentationHolder<BmpMonitorConfig>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._monitorId = base.getMonitorId();
        this._monitoredRouter = base.getMonitoredRouter();
        this._server = base.getServer();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.ServerConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.ServerConfig) {
            this._server = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.ServerConfig)arg).getServer();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.ServerConfig]");
    }

    public BmpMonitorConfigKey key() {
        return key;
    }
    
    public MonitorId getMonitorId() {
        return _monitorId;
    }
    
    public List<MonitoredRouter> getMonitoredRouter() {
        return _monitoredRouter;
    }
    
    public Server getServer() {
        return _server;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BmpMonitorConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public BmpMonitorConfigBuilder withKey(final BmpMonitorConfigKey key) {
        this.key = key;
        return this;
    }
    
    public BmpMonitorConfigBuilder setMonitorId(final MonitorId value) {
        this._monitorId = value;
        return this;
    }
    public BmpMonitorConfigBuilder setMonitoredRouter(final List<MonitoredRouter> values) {
        this._monitoredRouter = values;
        return this;
    }
    
    
    public BmpMonitorConfigBuilder setServer(final Server value) {
        this._server = value;
        return this;
    }
    
    public BmpMonitorConfigBuilder addAugmentation(Class<? extends Augmentation<BmpMonitorConfig>> augmentationType, Augmentation<BmpMonitorConfig> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public BmpMonitorConfigBuilder removeAugmentation(Class<? extends Augmentation<BmpMonitorConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BmpMonitorConfig build() {
        return new BmpMonitorConfigImpl(this);
    }

    private static final class BmpMonitorConfigImpl
        extends AbstractAugmentable<BmpMonitorConfig>
        implements BmpMonitorConfig {
    
        private final MonitorId _monitorId;
        private final List<MonitoredRouter> _monitoredRouter;
        private final Server _server;
        private final BmpMonitorConfigKey key;
    
        BmpMonitorConfigImpl(BmpMonitorConfigBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new BmpMonitorConfigKey(base.getMonitorId());
            }
            this._monitorId = key.getMonitorId();
            this._monitoredRouter = base.getMonitoredRouter();
            this._server = base.getServer();
        }
    
        @Override
        public BmpMonitorConfigKey key() {
            return key;
        }
        
        @Override
        public MonitorId getMonitorId() {
            return _monitorId;
        }
        
        @Override
        public List<MonitoredRouter> getMonitoredRouter() {
            return _monitoredRouter;
        }
        
        @Override
        public Server getServer() {
            return _server;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_monitorId);
            result = prime * result + Objects.hashCode(_monitoredRouter);
            result = prime * result + Objects.hashCode(_server);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BmpMonitorConfig.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            BmpMonitorConfig other = (BmpMonitorConfig)obj;
            if (!Objects.equals(_monitorId, other.getMonitorId())) {
                return false;
            }
            if (!Objects.equals(_monitoredRouter, other.getMonitoredRouter())) {
                return false;
            }
            if (!Objects.equals(_server, other.getServer())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                BmpMonitorConfigImpl otherImpl = (BmpMonitorConfigImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<BmpMonitorConfig>>, Augmentation<BmpMonitorConfig>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("BmpMonitorConfig");
            CodeHelpers.appendValue(helper, "_monitorId", _monitorId);
            CodeHelpers.appendValue(helper, "_monitoredRouter", _monitoredRouter);
            CodeHelpers.appendValue(helper, "_server", _server);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
