package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.BmpMonitorConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324.Rfc2385Key;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-bmp-monitor-config</b>
 * <pre>
 * list monitored-router {
 *   leaf address {
 *     type inet:ip-address-no-zone;
 *   }
 *   key address;
 *   leaf active {
 *     type boolean;
 *   }
 *   leaf port {
 *     when "../active = 'true'";
 *     type inet:port-number;
 *   }
 *   leaf password {
 *     type rfc2385:rfc2385-key;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-bmp-monitor-config/odl-bmp-monitors/bmp-monitor-config/monitored-router</i>
 *
 * <p>To create instances of this class use {@link MonitoredRouterBuilder}.
 * @see MonitoredRouterBuilder
 * @see MonitoredRouterKey
 *
 */
public interface MonitoredRouter
    extends
    ChildOf<BmpMonitorConfig>,
    Augmentable<MonitoredRouter>,
    Identifiable<MonitoredRouterKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("monitored-router");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config.MonitoredRouter.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone</code> <code>address</code>, or <code>null</code> if not present
     */
    @Nullable IpAddressNoZone getAddress();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>active</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isActive();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>port</code>, or <code>null</code> if not present
     */
    @Nullable PortNumber getPort();
    
    /**
     * RFC2385 shared secret
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324.Rfc2385Key</code> <code>password</code>, or <code>null</code> if not present
     */
    @Nullable Rfc2385Key getPassword();
    
    @Override
    MonitoredRouterKey key();

}

