package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.bmp.monitor.config;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class MonitoredRouterKey
 implements Identifier<MonitoredRouter> {
    private static final long serialVersionUID = -3086036492159455068L;
    private final IpAddressNoZone _address;


    public MonitoredRouterKey(IpAddressNoZone _address) {
    
        this._address = _address;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public MonitoredRouterKey(MonitoredRouterKey source) {
        this._address = source._address;
    }


    public IpAddressNoZone getAddress() {
        return _address;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_address);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MonitoredRouterKey)) {
            return false;
        }
        final MonitoredRouterKey other = (MonitoredRouterKey) obj;
        if (!Objects.equals(_address, other._address)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MonitoredRouterKey.class);
        CodeHelpers.appendValue(helper, "_address", _address);
        return helper.toString();
    }
}

