package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafi;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * grouping afi-safi-route-counter {
 *   list afi-safi {
 *     uses bgp-mp:bgp-table-type;
 *     key "afi safi";
 *     leaf count {
 *       type yang:gauge64;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/afi-safi-route-counter</i>
 *
 */
public interface AfiSafiRouteCounter
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("afi-safi-route-counter");

    @Override
    Class<? extends AfiSafiRouteCounter> implementedInterface();
    
    /**
     * @return <code>java.util.List</code> <code>afiSafi</code>, or <code>null</code> if not present
     */
    @Nullable List<AfiSafi> getAfiSafi();
    
    /**
     * @return <code>java.util.List</code> <code>afiSafi</code>, or an empty list if it is not present
     */
    default @NonNull List<AfiSafi> nonnullAfiSafi() {
        return CodeHelpers.nonnull(getAfiSafi());
    }

}

