package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * container bmp-monitor {
 *   list monitor {
 *     config false;
 *     key monitor-id;
 *     leaf monitor-id {
 *       type monitor-id;
 *     }
 *     uses routers;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/bmp-monitor</i>
 *
 * <p>To create instances of this class use {@link BmpMonitorBuilder}.
 * @see BmpMonitorBuilder
 *
 */
public interface BmpMonitor
    extends
    ChildOf<BmpMonitorData>,
    Augmentable<BmpMonitor>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("bmp-monitor");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.BmpMonitor> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.BmpMonitor.class;
    }
    
    /**
     * @return <code>java.util.List</code> <code>monitor</code>, or <code>null</code> if not present
     */
    @Nullable List<Monitor> getMonitor();
    
    /**
     * @return <code>java.util.List</code> <code>monitor</code>, or an empty list if it is not present
     */
    default @NonNull List<Monitor> nonnullMonitor() {
        return CodeHelpers.nonnull(getMonitor());
    }

}

