package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the base data model of a BMP monitor. Copyright (c)2015 
 * Cisco Systems, Inc. All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * module bmp-monitor {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:bmp-monitor;
 *   prefix bmp-mon;
 *   import bgp-rib {
 *     prefix rib;
 *     revision-date 2018-03-29;
 *   }
 *   import bgp-multiprotocol {
 *     prefix bgp-mp;
 *     revision-date 2018-03-29;
 *   }
 *   import bmp-message {
 *     prefix bmp-msg;
 *     revision-date 2020-01-20;
 *   }
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import ietf-yang-types {
 *     prefix yang;
 *     revision-date 2013-07-15;
 *   }
 *   revision 2020-01-20 {
 *   }
 *   revision 2018-03-29 {
 *   }
 *   revision 2017-12-07 {
 *   }
 *   revision 2015-05-12 {
 *   }
 *   typedef router-id {
 *     type inet:ip-address-no-zone;
 *   }
 *   typedef monitor-id {
 *     type string;
 *   }
 *   typedef status {
 *     type enumeration {
 *       enum up;
 *       enum down;
 *     }
 *   }
 *   grouping afi-safi-route-counter {
 *     list afi-safi {
 *       uses bgp-mp:bgp-table-type;
 *       key "afi safi";
 *       leaf count {
 *         type yang:gauge64;
 *       }
 *     }
 *   }
 *   grouping peers {
 *     list peer {
 *       key peer-id;
 *       leaf peer-id {
 *         type rib:peer-id;
 *       }
 *       uses bmp-msg:peer;
 *       leaf router-distinguisher {
 *         type string;
 *       }
 *       container peer-session {
 *         uses bmp-msg:peer-up;
 *         leaf status {
 *           type status;
 *         }
 *         uses bmp-msg:timestamp;
 *       }
 *       container stats {
 *         leaf rejected-prefixes {
 *           type yang:counter32;
 *         }
 *         leaf duplicate-prefix-advertisements {
 *           type yang:counter32;
 *         }
 *         leaf duplicate-withdraws {
 *           type yang:counter32;
 *         }
 *         leaf invalidated-cluster-list-loop {
 *           type yang:counter32;
 *         }
 *         leaf invalidated-as-path-loop {
 *           type yang:counter32;
 *         }
 *         leaf invalidated-originator-id {
 *           type yang:counter32;
 *         }
 *         leaf invalidated-as-confed-loop {
 *           type yang:counter32;
 *         }
 *         leaf adj-ribs-in-routes {
 *           type yang:gauge64;
 *         }
 *         leaf loc-rib-routes {
 *           type yang:gauge64;
 *         }
 *         container per-afi-safi-adj-rib-in-routes {
 *           uses afi-safi-route-counter;
 *         }
 *         container per-afi-safi-loc-rib-routes {
 *           uses afi-safi-route-counter;
 *         }
 *         leaf updates-treated-as-withdraw {
 *           type yang:counter32;
 *         }
 *         leaf prefixes-treated-as-withdraw {
 *           type yang:counter32;
 *         }
 *         leaf duplicate-updates {
 *           type yang:counter32;
 *         }
 *         uses bmp-msg:timestamp;
 *       }
 *       container pre-policy-rib {
 *         uses rib:rib;
 *       }
 *       container post-policy-rib {
 *         uses rib:rib;
 *       }
 *       container mirrors {
 *         leaf information {
 *           type bmp-msg:mirror-information-code;
 *         }
 *         uses bmp-msg:timestamp;
 *       }
 *     }
 *   }
 *   grouping routers {
 *     list router {
 *       key router-id;
 *       leaf name {
 *         type string;
 *       }
 *       leaf description {
 *         type string;
 *       }
 *       leaf info {
 *         type string;
 *       }
 *       leaf router-id {
 *         type router-id;
 *       }
 *       leaf status {
 *         type status;
 *       }
 *       uses peers;
 *     }
 *   }
 *   container bmp-monitor {
 *     list monitor {
 *       config false;
 *       key monitor-id;
 *       leaf monitor-id {
 *         type monitor-id;
 *       }
 *       uses routers;
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface BmpMonitorData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.BmpMonitor</code> <code>bmpMonitor</code>, or <code>null</code> if not present
     */
    @Nullable BmpMonitor getBmpMonitor();

}

