package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class MonitorId
 implements TypeObject, Serializable {
    private static final long serialVersionUID = -258589851360677782L;
    private final String _value;


    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public MonitorId(String _value) {
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public MonitorId(MonitorId source) {
        this._value = source._value;
    }

    public static MonitorId getDefaultInstance(String defaultValue) {
        return new MonitorId(defaultValue);
    }

    public String getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MonitorId)) {
            return false;
        }
        final MonitorId other = (MonitorId) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MonitorId.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

