package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * grouping peers {
 *   list peer {
 *     key peer-id;
 *     leaf peer-id {
 *       type rib:peer-id;
 *     }
 *     uses bmp-msg:peer;
 *     leaf router-distinguisher {
 *       type string;
 *     }
 *     container peer-session {
 *       uses bmp-msg:peer-up;
 *       leaf status {
 *         type status;
 *       }
 *       uses bmp-msg:timestamp;
 *     }
 *     container stats {
 *       leaf rejected-prefixes {
 *         type yang:counter32;
 *       }
 *       leaf duplicate-prefix-advertisements {
 *         type yang:counter32;
 *       }
 *       leaf duplicate-withdraws {
 *         type yang:counter32;
 *       }
 *       leaf invalidated-cluster-list-loop {
 *         type yang:counter32;
 *       }
 *       leaf invalidated-as-path-loop {
 *         type yang:counter32;
 *       }
 *       leaf invalidated-originator-id {
 *         type yang:counter32;
 *       }
 *       leaf invalidated-as-confed-loop {
 *         type yang:counter32;
 *       }
 *       leaf adj-ribs-in-routes {
 *         type yang:gauge64;
 *       }
 *       leaf loc-rib-routes {
 *         type yang:gauge64;
 *       }
 *       container per-afi-safi-adj-rib-in-routes {
 *         uses afi-safi-route-counter;
 *       }
 *       container per-afi-safi-loc-rib-routes {
 *         uses afi-safi-route-counter;
 *       }
 *       leaf updates-treated-as-withdraw {
 *         type yang:counter32;
 *       }
 *       leaf prefixes-treated-as-withdraw {
 *         type yang:counter32;
 *       }
 *       leaf duplicate-updates {
 *         type yang:counter32;
 *       }
 *       uses bmp-msg:timestamp;
 *     }
 *     container pre-policy-rib {
 *       uses rib:rib;
 *     }
 *     container post-policy-rib {
 *       uses rib:rib;
 *     }
 *     container mirrors {
 *       leaf information {
 *         type bmp-msg:mirror-information-code;
 *       }
 *       uses bmp-msg:timestamp;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/peers</i>
 *
 */
public interface Peers
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peers");

    @Override
    Class<? extends Peers> implementedInterface();
    
    /**
     * @return <code>java.util.List</code> <code>peer</code>, or <code>null</code> if not present
     */
    @Nullable List<Peer> getPeer();
    
    /**
     * @return <code>java.util.List</code> <code>peer</code>, or an empty list if it is not present
     */
    default @NonNull List<Peer> nonnullPeer() {
        return CodeHelpers.nonnull(getPeer());
    }

}

