package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers.Router;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * grouping routers {
 *   list router {
 *     key router-id;
 *     leaf name {
 *       type string;
 *     }
 *     leaf description {
 *       type string;
 *     }
 *     leaf info {
 *       type string;
 *     }
 *     leaf router-id {
 *       type router-id;
 *     }
 *     leaf status {
 *       type status;
 *     }
 *     uses peers;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/routers</i>
 *
 */
public interface Routers
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("routers");

    @Override
    Class<? extends Routers> implementedInterface();
    
    /**
     * @return <code>java.util.List</code> <code>router</code>, or <code>null</code> if not present
     */
    @Nullable List<Router> getRouter();
    
    /**
     * @return <code>java.util.List</code> <code>router</code>, or an empty list if it is not present
     */
    default @NonNull List<Router> nonnullRouter() {
        return CodeHelpers.nonnull(getRouter());
    }

}

