package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.AfiSafiRouteCounter;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * list afi-safi {
 *   uses bgp-mp:bgp-table-type;
 *   key "afi safi";
 *   leaf count {
 *     type yang:gauge64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/afi-safi-route-counter/afi-safi</i>
 *
 * <p>To create instances of this class use {@link AfiSafiBuilder}.
 * @see AfiSafiBuilder
 * @see AfiSafiKey
 *
 */
public interface AfiSafi
    extends
    ChildOf<AfiSafiRouteCounter>,
    Augmentable<AfiSafi>,
    BgpTableType,
    Identifiable<AfiSafiKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("afi-safi");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafi> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafi.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64</code> <code>count</code>, or <code>null</code> if not present
     */
    @Nullable Gauge64 getCount();
    
    @Override
    AfiSafiKey key();

}

