package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class AfiSafiKey
 implements Identifier<AfiSafi> {
    private static final long serialVersionUID = 7001011140625230602L;
    private final Class<? extends AddressFamily> _afi;
    private final Class<? extends SubsequentAddressFamily> _safi;


    public AfiSafiKey(Class<? extends AddressFamily> _afi, Class<? extends SubsequentAddressFamily> _safi) {
    
        this._afi = _afi;
        this._safi = _safi;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public AfiSafiKey(AfiSafiKey source) {
        this._afi = source._afi;
        this._safi = source._safi;
    }


    public Class<? extends AddressFamily> getAfi() {
        return _afi;
    }
    
    public Class<? extends SubsequentAddressFamily> getSafi() {
        return _safi;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_afi);
        result = prime * result + Objects.hashCode(_safi);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfiSafiKey)) {
            return false;
        }
        final AfiSafiKey other = (AfiSafiKey) obj;
        if (!Objects.equals(_afi, other._afi)) {
            return false;
        }
        if (!Objects.equals(_safi, other._safi)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(AfiSafiKey.class);
        CodeHelpers.appendValue(helper, "_afi", _afi);
        CodeHelpers.appendValue(helper, "_safi", _safi);
        return helper.toString();
    }
}

