package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.BmpMonitor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Routers;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * list monitor {
 *   config false;
 *   key monitor-id;
 *   leaf monitor-id {
 *     type monitor-id;
 *   }
 *   uses routers;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/bmp-monitor/monitor</i>
 *
 * <p>To create instances of this class use {@link MonitorBuilder}.
 * @see MonitorBuilder
 * @see MonitorKey
 *
 */
public interface Monitor
    extends
    ChildOf<BmpMonitor>,
    Augmentable<Monitor>,
    Routers,
    Identifiable<MonitorKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("monitor");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor.Monitor.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId</code> <code>monitorId</code>, or <code>null</code> if not present
     */
    @Nullable MonitorId getMonitorId();
    
    @Override
    MonitorKey key();

}

