package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.bmp.monitor;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.MonitorId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class MonitorKey
 implements Identifier<Monitor> {
    private static final long serialVersionUID = -2663145081987819938L;
    private final MonitorId _monitorId;


    public MonitorKey(MonitorId _monitorId) {
    
        this._monitorId = _monitorId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public MonitorKey(MonitorKey source) {
        this._monitorId = source._monitorId;
    }


    public MonitorId getMonitorId() {
        return _monitorId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_monitorId);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MonitorKey)) {
            return false;
        }
        final MonitorKey other = (MonitorKey) obj;
        if (!Objects.equals(_monitorId, other._monitorId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MonitorKey.class);
        CodeHelpers.appendValue(helper, "_monitorId", _monitorId);
        return helper.toString();
    }
}

