package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.Peers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PeerSession;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PostPolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PrePolicyRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * list peer {
 *   key peer-id;
 *   leaf peer-id {
 *     type rib:peer-id;
 *   }
 *   uses bmp-msg:peer;
 *   leaf router-distinguisher {
 *     type string;
 *   }
 *   container peer-session {
 *     uses bmp-msg:peer-up;
 *     leaf status {
 *       type status;
 *     }
 *     uses bmp-msg:timestamp;
 *   }
 *   container stats {
 *     leaf rejected-prefixes {
 *       type yang:counter32;
 *     }
 *     leaf duplicate-prefix-advertisements {
 *       type yang:counter32;
 *     }
 *     leaf duplicate-withdraws {
 *       type yang:counter32;
 *     }
 *     leaf invalidated-cluster-list-loop {
 *       type yang:counter32;
 *     }
 *     leaf invalidated-as-path-loop {
 *       type yang:counter32;
 *     }
 *     leaf invalidated-originator-id {
 *       type yang:counter32;
 *     }
 *     leaf invalidated-as-confed-loop {
 *       type yang:counter32;
 *     }
 *     leaf adj-ribs-in-routes {
 *       type yang:gauge64;
 *     }
 *     leaf loc-rib-routes {
 *       type yang:gauge64;
 *     }
 *     container per-afi-safi-adj-rib-in-routes {
 *       uses afi-safi-route-counter;
 *     }
 *     container per-afi-safi-loc-rib-routes {
 *       uses afi-safi-route-counter;
 *     }
 *     leaf updates-treated-as-withdraw {
 *       type yang:counter32;
 *     }
 *     leaf prefixes-treated-as-withdraw {
 *       type yang:counter32;
 *     }
 *     leaf duplicate-updates {
 *       type yang:counter32;
 *     }
 *     uses bmp-msg:timestamp;
 *   }
 *   container pre-policy-rib {
 *     uses rib:rib;
 *   }
 *   container post-policy-rib {
 *     uses rib:rib;
 *   }
 *   container mirrors {
 *     leaf information {
 *       type bmp-msg:mirror-information-code;
 *     }
 *     uses bmp-msg:timestamp;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/peers/peer</i>
 *
 * <p>To create instances of this class use {@link PeerBuilder}.
 * @see PeerBuilder
 * @see PeerKey
 *
 */
public interface Peer
    extends
    ChildOf<Peers>,
    Augmentable<Peer>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer,
    Identifiable<PeerKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId</code> <code>peerId</code>, or <code>null</code> if not present
     */
    @Nullable PeerId getPeerId();
    
    /**
     * @return <code>java.lang.String</code> <code>routerDistinguisher</code>, or <code>null</code> if not present
     */
    @Nullable String getRouterDistinguisher();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PeerSession</code> <code>peerSession</code>, or <code>null</code> if not present
     */
    @Nullable PeerSession getPeerSession();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats</code> <code>stats</code>, or <code>null</code> if not present
     */
    @Nullable Stats getStats();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PrePolicyRib</code> <code>prePolicyRib</code>, or <code>null</code> if not present
     */
    @Nullable PrePolicyRib getPrePolicyRib();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.PostPolicyRib</code> <code>postPolicyRib</code>, or <code>null</code> if not present
     */
    @Nullable PostPolicyRib getPostPolicyRib();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors</code> <code>mirrors</code>, or <code>null</code> if not present
     */
    @Nullable Mirrors getMirrors();
    
    @Override
    PeerKey key();

}

