package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class PeerKey
 implements Identifier<Peer> {
    private static final long serialVersionUID = -5141624888529198950L;
    private final PeerId _peerId;


    public PeerKey(PeerId _peerId) {
    
        this._peerId = _peerId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PeerKey(PeerKey source) {
        this._peerId = source._peerId;
    }


    public PeerId getPeerId() {
        return _peerId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_peerId);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PeerKey)) {
            return false;
        }
        final PeerKey other = (PeerKey) obj;
        if (!Objects.equals(_peerId, other._peerId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(PeerKey.class);
        CodeHelpers.appendValue(helper, "_peerId", _peerId);
        return helper.toString();
    }
}

