package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.MirrorInformationCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * container mirrors {
 *   leaf information {
 *     type bmp-msg:mirror-information-code;
 *   }
 *   uses bmp-msg:timestamp;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/peers/peer/mirrors</i>
 *
 * <p>To create instances of this class use {@link MirrorsBuilder}.
 * @see MirrorsBuilder
 *
 */
public interface Mirrors
    extends
    ChildOf<Peer>,
    Augmentable<Mirrors>,
    Timestamp
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mirrors");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Mirrors.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.MirrorInformationCode</code> <code>information</code>, or <code>null</code> if not present
     */
    @Nullable MirrorInformationCode getInformation();

}

