package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.MirrorInformationCode;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link MirrorsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MirrorsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new MirrorsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MirrorsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MirrorsBuilder
 * @see Builder
 *
 */
public class MirrorsBuilder implements Builder<Mirrors> {

    private MirrorInformationCode _information;
    private Timestamp _timestampMicro;
    private Timestamp _timestampSec;


    Map<Class<? extends Augmentation<Mirrors>>, Augmentation<Mirrors>> augmentation = Collections.emptyMap();

    public MirrorsBuilder() {
    }
    public MirrorsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp arg) {
        this._timestampSec = arg.getTimestampSec();
        this._timestampMicro = arg.getTimestampMicro();
    }

    public MirrorsBuilder(Mirrors base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Mirrors>>, Augmentation<Mirrors>> aug =((AugmentationHolder<Mirrors>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._information = base.getInformation();
        this._timestampMicro = base.getTimestampMicro();
        this._timestampSec = base.getTimestampSec();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp) {
            this._timestampSec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampSec();
            this._timestampMicro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampMicro();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp]");
    }

    public MirrorInformationCode getInformation() {
        return _information;
    }
    
    public Timestamp getTimestampMicro() {
        return _timestampMicro;
    }
    
    public Timestamp getTimestampSec() {
        return _timestampSec;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Mirrors>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public MirrorsBuilder setInformation(final MirrorInformationCode value) {
        this._information = value;
        return this;
    }
    
    public MirrorsBuilder setTimestampMicro(final Timestamp value) {
        this._timestampMicro = value;
        return this;
    }
    
    public MirrorsBuilder setTimestampSec(final Timestamp value) {
        this._timestampSec = value;
        return this;
    }
    
    public MirrorsBuilder addAugmentation(Class<? extends Augmentation<Mirrors>> augmentationType, Augmentation<Mirrors> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public MirrorsBuilder removeAugmentation(Class<? extends Augmentation<Mirrors>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Mirrors build() {
        return new MirrorsImpl(this);
    }

    private static final class MirrorsImpl
        extends AbstractAugmentable<Mirrors>
        implements Mirrors {
    
        private final MirrorInformationCode _information;
        private final Timestamp _timestampMicro;
        private final Timestamp _timestampSec;
    
        MirrorsImpl(MirrorsBuilder base) {
            super(base.augmentation);
            this._information = base.getInformation();
            this._timestampMicro = base.getTimestampMicro();
            this._timestampSec = base.getTimestampSec();
        }
    
        @Override
        public MirrorInformationCode getInformation() {
            return _information;
        }
        
        @Override
        public Timestamp getTimestampMicro() {
            return _timestampMicro;
        }
        
        @Override
        public Timestamp getTimestampSec() {
            return _timestampSec;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_information);
            result = prime * result + Objects.hashCode(_timestampMicro);
            result = prime * result + Objects.hashCode(_timestampSec);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mirrors.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Mirrors other = (Mirrors)obj;
            if (!Objects.equals(_information, other.getInformation())) {
                return false;
            }
            if (!Objects.equals(_timestampMicro, other.getTimestampMicro())) {
                return false;
            }
            if (!Objects.equals(_timestampSec, other.getTimestampSec())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MirrorsImpl otherImpl = (MirrorsImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Mirrors>>, Augmentation<Mirrors>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Mirrors");
            CodeHelpers.appendValue(helper, "_information", _information);
            CodeHelpers.appendValue(helper, "_timestampMicro", _timestampMicro);
            CodeHelpers.appendValue(helper, "_timestampSec", _timestampSec);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
