package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats.PerAfiSafiAdjRibInRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats.PerAfiSafiLocRibRoutes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-monitor</b>
 * <pre>
 * container stats {
 *   leaf rejected-prefixes {
 *     type yang:counter32;
 *   }
 *   leaf duplicate-prefix-advertisements {
 *     type yang:counter32;
 *   }
 *   leaf duplicate-withdraws {
 *     type yang:counter32;
 *   }
 *   leaf invalidated-cluster-list-loop {
 *     type yang:counter32;
 *   }
 *   leaf invalidated-as-path-loop {
 *     type yang:counter32;
 *   }
 *   leaf invalidated-originator-id {
 *     type yang:counter32;
 *   }
 *   leaf invalidated-as-confed-loop {
 *     type yang:counter32;
 *   }
 *   leaf adj-ribs-in-routes {
 *     type yang:gauge64;
 *   }
 *   leaf loc-rib-routes {
 *     type yang:gauge64;
 *   }
 *   container per-afi-safi-adj-rib-in-routes {
 *     uses afi-safi-route-counter;
 *   }
 *   container per-afi-safi-loc-rib-routes {
 *     uses afi-safi-route-counter;
 *   }
 *   leaf updates-treated-as-withdraw {
 *     type yang:counter32;
 *   }
 *   leaf prefixes-treated-as-withdraw {
 *     type yang:counter32;
 *   }
 *   leaf duplicate-updates {
 *     type yang:counter32;
 *   }
 *   uses bmp-msg:timestamp;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-monitor/peers/peer/stats</i>
 *
 * <p>To create instances of this class use {@link StatsBuilder}.
 * @see StatsBuilder
 *
 */
public interface Stats
    extends
    ChildOf<Peer>,
    Augmentable<Stats>,
    Timestamp
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("stats");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.Stats.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>rejectedPrefixes</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getRejectedPrefixes();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>duplicatePrefixAdvertisements</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getDuplicatePrefixAdvertisements();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>duplicateWithdraws</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getDuplicateWithdraws();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>invalidatedClusterListLoop</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getInvalidatedClusterListLoop();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>invalidatedAsPathLoop</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getInvalidatedAsPathLoop();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>invalidatedOriginatorId</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getInvalidatedOriginatorId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>invalidatedAsConfedLoop</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getInvalidatedAsConfedLoop();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64</code> <code>adjRibsInRoutes</code>, or <code>null</code> if not present
     */
    @Nullable Gauge64 getAdjRibsInRoutes();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64</code> <code>locRibRoutes</code>, or <code>null</code> if not present
     */
    @Nullable Gauge64 getLocRibRoutes();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats.PerAfiSafiAdjRibInRoutes</code> <code>perAfiSafiAdjRibInRoutes</code>, or <code>null</code> if not present
     */
    @Nullable PerAfiSafiAdjRibInRoutes getPerAfiSafiAdjRibInRoutes();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats.PerAfiSafiLocRibRoutes</code> <code>perAfiSafiLocRibRoutes</code>, or <code>null</code> if not present
     */
    @Nullable PerAfiSafiLocRibRoutes getPerAfiSafiLocRibRoutes();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>updatesTreatedAsWithdraw</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getUpdatesTreatedAsWithdraw();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>prefixesTreatedAsWithdraw</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getPrefixesTreatedAsWithdraw();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32</code> <code>duplicateUpdates</code>, or <code>null</code> if not present
     */
    @Nullable Counter32 getDuplicateUpdates();

}

