package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.peers.peer.stats;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.afi.safi.route.counter.AfiSafi;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PerAfiSafiAdjRibInRoutesBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PerAfiSafiAdjRibInRoutesBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PerAfiSafiAdjRibInRoutesBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PerAfiSafiAdjRibInRoutesBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PerAfiSafiAdjRibInRoutesBuilder
 * @see Builder
 *
 */
public class PerAfiSafiAdjRibInRoutesBuilder implements Builder<PerAfiSafiAdjRibInRoutes> {

    private List<AfiSafi> _afiSafi;


    Map<Class<? extends Augmentation<PerAfiSafiAdjRibInRoutes>>, Augmentation<PerAfiSafiAdjRibInRoutes>> augmentation = Collections.emptyMap();

    public PerAfiSafiAdjRibInRoutesBuilder() {
    }
    public PerAfiSafiAdjRibInRoutesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.AfiSafiRouteCounter arg) {
        this._afiSafi = arg.getAfiSafi();
    }

    public PerAfiSafiAdjRibInRoutesBuilder(PerAfiSafiAdjRibInRoutes base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<PerAfiSafiAdjRibInRoutes>>, Augmentation<PerAfiSafiAdjRibInRoutes>> aug =((AugmentationHolder<PerAfiSafiAdjRibInRoutes>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._afiSafi = base.getAfiSafi();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.AfiSafiRouteCounter</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.AfiSafiRouteCounter) {
            this._afiSafi = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.AfiSafiRouteCounter)arg).getAfiSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.AfiSafiRouteCounter]");
    }

    public List<AfiSafi> getAfiSafi() {
        return _afiSafi;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PerAfiSafiAdjRibInRoutes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PerAfiSafiAdjRibInRoutesBuilder setAfiSafi(final List<AfiSafi> values) {
        this._afiSafi = values;
        return this;
    }
    
    
    public PerAfiSafiAdjRibInRoutesBuilder addAugmentation(Class<? extends Augmentation<PerAfiSafiAdjRibInRoutes>> augmentationType, Augmentation<PerAfiSafiAdjRibInRoutes> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public PerAfiSafiAdjRibInRoutesBuilder removeAugmentation(Class<? extends Augmentation<PerAfiSafiAdjRibInRoutes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PerAfiSafiAdjRibInRoutes build() {
        return new PerAfiSafiAdjRibInRoutesImpl(this);
    }

    private static final class PerAfiSafiAdjRibInRoutesImpl
        extends AbstractAugmentable<PerAfiSafiAdjRibInRoutes>
        implements PerAfiSafiAdjRibInRoutes {
    
        private final List<AfiSafi> _afiSafi;
    
        PerAfiSafiAdjRibInRoutesImpl(PerAfiSafiAdjRibInRoutesBuilder base) {
            super(base.augmentation);
            this._afiSafi = base.getAfiSafi();
        }
    
        @Override
        public List<AfiSafi> getAfiSafi() {
            return _afiSafi;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_afiSafi);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PerAfiSafiAdjRibInRoutes.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            PerAfiSafiAdjRibInRoutes other = (PerAfiSafiAdjRibInRoutes)obj;
            if (!Objects.equals(_afiSafi, other.getAfiSafi())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PerAfiSafiAdjRibInRoutesImpl otherImpl = (PerAfiSafiAdjRibInRoutesImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<PerAfiSafiAdjRibInRoutes>>, Augmentation<PerAfiSafiAdjRibInRoutes>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PerAfiSafiAdjRibInRoutes");
            CodeHelpers.appendValue(helper, "_afiSafi", _afiSafi);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
