package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.routers;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.rev200120.RouterId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class RouterKey
 implements Identifier<Router> {
    private static final long serialVersionUID = 3394032616092560282L;
    private final RouterId _routerId;


    public RouterKey(RouterId _routerId) {
    
        this._routerId = _routerId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public RouterKey(RouterKey source) {
        this._routerId = source._routerId;
    }


    public RouterId getRouterId() {
        return _routerId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_routerId);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RouterKey)) {
            return false;
        }
        final RouterKey other = (RouterKey) obj;
        if (!Objects.equals(_routerId, other._routerId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(RouterKey.class);
        CodeHelpers.appendValue(helper, "_routerId", _routerId);
        return helper.toString();
    }
}

