package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping count-tlv {
 *   uses tlv;
 *   leaf count {
 *     type yang:counter32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/count-tlv</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface CountTlv
    extends
    DataObject,
    Tlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("count-tlv");

    @Override
    Class<? extends CountTlv> implementedInterface();
    
    /**
     * Return count, or {@code null} if it is not present.
     *
     * @return {@code Counter32} count, or {@code null} if it is not present.
     *
     */
    Counter32 getCount();
    
    /**
     * Return count, guaranteed to be non-null.
     *
     * @return {@code Counter32} count, guaranteed to be non-null.
     * @throws NoSuchElementException if count is not present
     *
     */
    default @NonNull Counter32 requireCount() {
        return CodeHelpers.require(getCount(), "count");
    }

}

