package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping gauge-tlv {
 *   uses tlv;
 *   leaf count {
 *     type yang:gauge64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/gauge-tlv</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface GaugeTlv
    extends
    DataObject,
    Tlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("gauge-tlv");

    @Override
    Class<? extends GaugeTlv> implementedInterface();
    
    /**
     * Return count, or {@code null} if it is not present.
     *
     * @return {@code Gauge64} count, or {@code null} if it is not present.
     *
     */
    Gauge64 getCount();
    
    /**
     * Return count, guaranteed to be non-null.
     *
     * @return {@code Gauge64} count, guaranteed to be non-null.
     * @throws NoSuchElementException if count is not present
     *
     */
    default @NonNull Gauge64 requireCount() {
        return CodeHelpers.require(getCount(), "count");
    }

}

