package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.Data;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping peer-down {
 *   leaf local-system-closed {
 *     type boolean;
 *   }
 *   choice data {
 *     case notification {
 *       container notification {
 *         uses bgp-msg:notify-message;
 *       }
 *     }
 *     case fsm-event-code {
 *       leaf fsm-event-code {
 *         type uint16;
 *         default 0;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-down</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface PeerDown
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-down");

    @Override
    Class<? extends PeerDown> implementedInterface();
    
    /**
     * Return localSystemClosed, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         If set true, the local system closed the session. Otherwise the remote system
     *         closed the session.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} localSystemClosed, or {@code null} if it is not present.
     *
     */
    Boolean getLocalSystemClosed();
    
    /**
     * Return localSystemClosed, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         If set true, the local system closed the session. Otherwise the remote system
     *         closed the session.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} localSystemClosed, guaranteed to be non-null.
     * @throws NoSuchElementException if localSystemClosed is not present
     *
     */
    default @NonNull Boolean requireLocalSystemClosed() {
        return CodeHelpers.require(getLocalSystemClosed(), "localsystemclosed");
    }
    
    /**
     * Return data, or {@code null} if it is not present.
     *
     * @return {@code Data} data, or {@code null} if it is not present.
     *
     */
    Data getData();

}

