package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The per-peer header follows the common header for most BMP messages. The rest 
 * the data in a BMP message is dependent on the Message Type field in the common 
 * header.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping peer-header {
 *   container peer-header {
 *     uses peer;
 *     uses timestamp;
 *     leaf adj-rib-in-type {
 *       type adj-rib-in-type;
 *     }
 *     leaf ipv4 {
 *       type boolean;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-header</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface PeerHeader
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-header");

    @Override
    Class<? extends PeerHeader> implementedInterface();
    
    /**
     * Return peerHeader, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader} peerHeader, or {@code null} if it is not present.
     *
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader getPeerHeader();

}

