package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum PeerType implements Enumeration {
    /**
     * Global Instance Peer.
     */
    Global(0, "global"),
    
    /**
     * RD Instance Peer.
     */
    L3vpn(1, "l3vpn"),
    
    /**
     * Local Instance Peer
     */
    Local(2, "local")
    ;

    private static final Map<String, PeerType> NAME_MAP;
    private static final Map<Integer, PeerType> VALUE_MAP;

    static {
        final Builder<String, PeerType> nb = ImmutableMap.builder();
        final Builder<Integer, PeerType> vb = ImmutableMap.builder();
        for (PeerType enumItem : PeerType.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private PeerType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding PeerType item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<PeerType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding PeerType item, or null if no such item exists
     */
    public static PeerType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
