package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.Information;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.ReceivedOpen;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.up.SentOpen;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping peer-up {
 *   leaf local-address {
 *     type inet:ip-address-no-zone;
 *   }
 *   leaf local-port {
 *     type inet:port-number;
 *   }
 *   leaf remote-port {
 *     type inet:port-number;
 *   }
 *   container sent-open {
 *     uses open-msg;
 *   }
 *   container received-open {
 *     uses open-msg;
 *   }
 *   container information {
 *     uses string-informations;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-up</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface PeerUp
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-up");

    @Override
    Class<? extends PeerUp> implementedInterface();
    
    /**
     * Return localAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The local IP address associated with the peering TCP session.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddressNoZone} localAddress, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getLocalAddress();
    
    /**
     * Return localAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The local IP address associated with the peering TCP session.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddressNoZone} localAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if localAddress is not present
     *
     */
    default @NonNull IpAddressNoZone requireLocalAddress() {
        return CodeHelpers.require(getLocalAddress(), "localaddress");
    }
    
    /**
     * Return localPort, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The local port number associated with the peering TCP session.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} localPort, or {@code null} if it is not present.
     *
     */
    PortNumber getLocalPort();
    
    /**
     * Return localPort, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The local port number associated with the peering TCP session.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} localPort, guaranteed to be non-null.
     * @throws NoSuchElementException if localPort is not present
     *
     */
    default @NonNull PortNumber requireLocalPort() {
        return CodeHelpers.require(getLocalPort(), "localport");
    }
    
    /**
     * Return remotePort, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The remote port number associated with the peering TCP session.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} remotePort, or {@code null} if it is not present.
     *
     */
    PortNumber getRemotePort();
    
    /**
     * Return remotePort, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The remote port number associated with the peering TCP session.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} remotePort, guaranteed to be non-null.
     * @throws NoSuchElementException if remotePort is not present
     *
     */
    default @NonNull PortNumber requireRemotePort() {
        return CodeHelpers.require(getRemotePort(), "remoteport");
    }
    
    /**
     * Return sentOpen, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The full OPEN message transmitted by the monitored router to its peer.
     *     </code>
     * </pre>
     *
     * @return {@code SentOpen} sentOpen, or {@code null} if it is not present.
     *
     */
    SentOpen getSentOpen();
    
    /**
     * Return receivedOpen, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The full OPEN message received by the monitored router from its peer.
     *     </code>
     * </pre>
     *
     * @return {@code ReceivedOpen} receivedOpen, or {@code null} if it is not present.
     *
     */
    ReceivedOpen getReceivedOpen();
    
    /**
     * Return information, or {@code null} if it is not present.
     *
     * @return {@code Information} information, or {@code null} if it is not present.
     *
     */
    Information getInformation();

}

