package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The Peer Up message is used to indicate that a peering session has come up 
 * (i.e., has transitioned into ESTABLISHED state).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * notification peer-up-notification {
 *   uses peer-header;
 *   uses peer-up;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-up-notification</i>
 *
 * <p>To create instances of this class use {@link PeerUpNotificationBuilder}.
 * @see PeerUpNotificationBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PeerUpNotification
    extends
    DataObject,
    Notification,
    Augmentable<PeerUpNotification>,
    PeerHeader,
    PeerUp
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-up-notification");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.@NonNull PeerUpNotification obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getInformation());
        result = prime * result + Objects.hashCode(obj.getLocalAddress());
        result = prime * result + Objects.hashCode(obj.getLocalPort());
        result = prime * result + Objects.hashCode(obj.getPeerHeader());
        result = prime * result + Objects.hashCode(obj.getReceivedOpen());
        result = prime * result + Objects.hashCode(obj.getRemotePort());
        result = prime * result + Objects.hashCode(obj.getSentOpen());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.@NonNull PeerUpNotification thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerUpNotification.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getLocalPort(), other.getLocalPort())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRemotePort(), other.getRemotePort())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInformation(), other.getInformation())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLocalAddress(), other.getLocalAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPeerHeader(), other.getPeerHeader())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReceivedOpen(), other.getReceivedOpen())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSentOpen(), other.getSentOpen())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.@NonNull PeerUpNotification obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PeerUpNotification");
        CodeHelpers.appendValue(helper, "information", obj.getInformation());
        CodeHelpers.appendValue(helper, "localAddress", obj.getLocalAddress());
        CodeHelpers.appendValue(helper, "localPort", obj.getLocalPort());
        CodeHelpers.appendValue(helper, "peerHeader", obj.getPeerHeader());
        CodeHelpers.appendValue(helper, "receivedOpen", obj.getReceivedOpen());
        CodeHelpers.appendValue(helper, "remotePort", obj.getRemotePort());
        CodeHelpers.appendValue(helper, "sentOpen", obj.getSentOpen());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }

}

