package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum Reason implements Enumeration {
    /**
     * Session administratively closed.
     */
    AdministrativelyClosed(0, "administratively-closed"),
    
    /**
     * Unspecified reason.
     */
    Unspecified(1, "unspecified"),
    
    /**
     * Out of resources. The router has exhausted
     * resources available for the BMP session.
     */
    OutOfResources(2, "out-of-resources"),
    
    /**
     * Redundant connection. The router has determined
     * that this connection is redundant with another one.
     */
    RedundantConnection(3, "redundant-connection"),
    
    /**
     * Session permanently administratively closed,
     * will not be re-initiated.  Monitoring station should reduce
     * (potentially to 0) the rate at which it attempts
     * reconnection to the monitored router.
     */
    PermanentlyClosed(4, "permanently-closed")
    ;

    private static final Map<String, Reason> NAME_MAP;
    private static final Map<Integer, Reason> VALUE_MAP;

    static {
        final Builder<String, Reason> nb = ImmutableMap.builder();
        final Builder<Integer, Reason> vb = ImmutableMap.builder();
        for (Reason enumItem : Reason.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private Reason(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding Reason item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<Reason> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding Reason item, or null if no such item exists
     */
    public static Reason forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
