package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RouteMirroringMessageBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RouteMirroringMessageBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RouteMirroringMessageBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RouteMirroringMessageBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RouteMirroringMessageBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class RouteMirroringMessageBuilder implements Builder<RouteMirroringMessage> {

    private PeerHeader _peerHeader;
    private Tlvs _tlvs;


    Map<Class<? extends Augmentation<RouteMirroringMessage>>, Augmentation<RouteMirroringMessage>> augmentation = Collections.emptyMap();

    public RouteMirroringMessageBuilder() {
    }
    
    
    
    
    public RouteMirroringMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader arg) {
        this._peerHeader = arg.getPeerHeader();
    }
    
    public RouteMirroringMessageBuilder(Mirror arg) {
        this._tlvs = arg.getTlvs();
    }

    public RouteMirroringMessageBuilder(RouteMirroringMessage base) {
        Map<Class<? extends Augmentation<RouteMirroringMessage>>, Augmentation<RouteMirroringMessage>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._peerHeader = base.getPeerHeader();
        this._tlvs = base.getTlvs();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Mirror</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Mirror) {
            this._tlvs = ((Mirror)arg).getTlvs();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader) {
            this._peerHeader = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader)arg).getPeerHeader();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Mirror, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader]");
    }

    public PeerHeader getPeerHeader() {
        return _peerHeader;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RouteMirroringMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public RouteMirroringMessageBuilder setPeerHeader(final PeerHeader value) {
        this._peerHeader = value;
        return this;
    }
    
    public RouteMirroringMessageBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public RouteMirroringMessageBuilder addAugmentation(Augmentation<RouteMirroringMessage> augmentation) {
        Class<? extends Augmentation<RouteMirroringMessage>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public RouteMirroringMessageBuilder removeAugmentation(Class<? extends Augmentation<RouteMirroringMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RouteMirroringMessage build() {
        return new RouteMirroringMessageImpl(this);
    }

    private static final class RouteMirroringMessageImpl
        extends AbstractAugmentable<RouteMirroringMessage>
        implements RouteMirroringMessage {
    
        private final PeerHeader _peerHeader;
        private final Tlvs _tlvs;
    
        RouteMirroringMessageImpl(RouteMirroringMessageBuilder base) {
            super(base.augmentation);
            this._peerHeader = base.getPeerHeader();
            this._tlvs = base.getTlvs();
        }
    
        @Override
        public PeerHeader getPeerHeader() {
            return _peerHeader;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = RouteMirroringMessage.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return RouteMirroringMessage.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return RouteMirroringMessage.bindingToString(this);
        }
    }
}
