package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.route.monitoring.message.Update;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Route Monitoring messages are used for initial synchronization of ADJ-RIBs-In. 
 * They are also used for ongoing monitoring of received advertisements and 
 * withdraws.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * notification route-monitoring-message {
 *   uses peer-header;
 *   container update {
 *     uses bgp-msg:update-message;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/route-monitoring-message</i>
 *
 * <p>To create instances of this class use {@link RouteMonitoringMessageBuilder}.
 * @see RouteMonitoringMessageBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface RouteMonitoringMessage
    extends
    DataObject,
    Notification,
    Augmentable<RouteMonitoringMessage>,
    PeerHeader
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("route-monitoring-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.@NonNull RouteMonitoringMessage obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getPeerHeader());
        result = prime * result + Objects.hashCode(obj.getUpdate());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.@NonNull RouteMonitoringMessage thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.RouteMonitoringMessage.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getPeerHeader(), other.getPeerHeader())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUpdate(), other.getUpdate())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.@NonNull RouteMonitoringMessage obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RouteMonitoringMessage");
        CodeHelpers.appendValue(helper, "peerHeader", obj.getPeerHeader());
        CodeHelpers.appendValue(helper, "update", obj.getUpdate());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return update, or {@code null} if it is not present.
     *
     * @return {@code Update} update, or {@code null} if it is not present.
     *
     */
    Update getUpdate();

}

