package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.AdjRibsInRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicatePrefixAdvertisementsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateUpdatesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.DuplicateWithdrawsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsConfedLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedAsPathLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedClusterListLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.InvalidatedOriginatorIdTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.LocRibRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiAdjRibInTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PerAfiSafiLocRibTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.PrefixesTreatedAsWithdrawTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.RejectedPrefixesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.tlvs.UpdatesTreatedAsWithdrawTlv;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Each counter is encoded as a TLV.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping stat-tlvs {
 *   container rejected-prefixes-tlv {
 *     uses count-tlv;
 *   }
 *   container duplicate-prefix-advertisements-tlv {
 *     uses count-tlv;
 *   }
 *   container duplicate-withdraws-tlv {
 *     uses count-tlv;
 *   }
 *   container invalidated-cluster-list-loop-tlv {
 *     uses count-tlv;
 *   }
 *   container invalidated-as-path-loop-tlv {
 *     uses count-tlv;
 *   }
 *   container invalidated-originator-id-tlv {
 *     uses count-tlv;
 *   }
 *   container invalidated-as-confed-loop-tlv {
 *     uses count-tlv;
 *   }
 *   container adj-ribs-in-routes-tlv {
 *     uses gauge-tlv;
 *   }
 *   container loc-rib-routes-tlv {
 *     uses gauge-tlv;
 *   }
 *   container per-afi-safi-adj-rib-in-tlv {
 *     uses afi-safi-gauge-tlv;
 *   }
 *   container per-afi-safi-loc-rib-tlv {
 *     uses afi-safi-gauge-tlv;
 *   }
 *   container updates-treated-as-withdraw-tlv {
 *     uses count-tlv;
 *   }
 *   container prefixes-treated-as-withdraw-tlv {
 *     uses count-tlv;
 *   }
 *   container duplicate-updates-tlv {
 *     uses count-tlv;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/stat-tlvs</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface StatTlvs
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("stat-tlvs");

    @Override
    Class<? extends StatTlvs> implementedInterface();
    
    /**
     * Return rejectedPrefixesTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 0: (32-bit Counter) Number of prefixes rejected by inbound policy.
     *     </code>
     * </pre>
     *
     * @return {@code RejectedPrefixesTlv} rejectedPrefixesTlv, or {@code null} if it is not present.
     *
     */
    RejectedPrefixesTlv getRejectedPrefixesTlv();
    
    /**
     * Return duplicatePrefixAdvertisementsTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 1: (32-bit Counter) Number of (known) duplicate prefix
     *         advertisements.
     *     </code>
     * </pre>
     *
     * @return {@code DuplicatePrefixAdvertisementsTlv} duplicatePrefixAdvertisementsTlv, or {@code null} if it is not present.
     *
     */
    DuplicatePrefixAdvertisementsTlv getDuplicatePrefixAdvertisementsTlv();
    
    /**
     * Return duplicateWithdrawsTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 2: (32-bit Counter) Number of (known) duplicate withdraws.
     *     </code>
     * </pre>
     *
     * @return {@code DuplicateWithdrawsTlv} duplicateWithdrawsTlv, or {@code null} if it is not present.
     *
     */
    DuplicateWithdrawsTlv getDuplicateWithdrawsTlv();
    
    /**
     * Return invalidatedClusterListLoopTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 3: (32-bit Counter) Number of updates invalidated due to
     *         CLUSTER_LIST loop.
     *     </code>
     * </pre>
     *
     * @return {@code InvalidatedClusterListLoopTlv} invalidatedClusterListLoopTlv, or {@code null} if it is not present.
     *
     */
    InvalidatedClusterListLoopTlv getInvalidatedClusterListLoopTlv();
    
    /**
     * Return invalidatedAsPathLoopTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 4: (32-bit Counter) Number of updates invalidated due to AS_PATH
     *         loop.
     *     </code>
     * </pre>
     *
     * @return {@code InvalidatedAsPathLoopTlv} invalidatedAsPathLoopTlv, or {@code null} if it is not present.
     *
     */
    InvalidatedAsPathLoopTlv getInvalidatedAsPathLoopTlv();
    
    /**
     * Return invalidatedOriginatorIdTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 5: (32-bit Counter) Number of updates invalidated due to
     *         ORIGINATOR_ID.
     *     </code>
     * </pre>
     *
     * @return {@code InvalidatedOriginatorIdTlv} invalidatedOriginatorIdTlv, or {@code null} if it is not present.
     *
     */
    InvalidatedOriginatorIdTlv getInvalidatedOriginatorIdTlv();
    
    /**
     * Return invalidatedAsConfedLoopTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 6: (32-bit Counter) Number of updates invalidated due to AS_CONFED
     *         loop.
     *     </code>
     * </pre>
     *
     * @return {@code InvalidatedAsConfedLoopTlv} invalidatedAsConfedLoopTlv, or {@code null} if it is not present.
     *
     */
    InvalidatedAsConfedLoopTlv getInvalidatedAsConfedLoopTlv();
    
    /**
     * Return adjRibsInRoutesTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 7: (64-bit Gauge) Number of routes in Adj-RIBs-In.
     *     </code>
     * </pre>
     *
     * @return {@code AdjRibsInRoutesTlv} adjRibsInRoutesTlv, or {@code null} if it is not present.
     *
     */
    AdjRibsInRoutesTlv getAdjRibsInRoutesTlv();
    
    /**
     * Return locRibRoutesTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 8: (64-bit Gauge) Number of routes in Loc-RIB.
     *     </code>
     * </pre>
     *
     * @return {@code LocRibRoutesTlv} locRibRoutesTlv, or {@code null} if it is not present.
     *
     */
    LocRibRoutesTlv getLocRibRoutesTlv();
    
    /**
     * Return perAfiSafiAdjRibInTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 9: Number of routes in per-AFI/SAFI Adj-RIB-In. The value is
     *         structured as: AFI (2 bytes), SAFI (1 byte), followed by a 64-bit Gauge.
     *     </code>
     * </pre>
     *
     * @return {@code PerAfiSafiAdjRibInTlv} perAfiSafiAdjRibInTlv, or {@code null} if it is not present.
     *
     */
    PerAfiSafiAdjRibInTlv getPerAfiSafiAdjRibInTlv();
    
    /**
     * Return perAfiSafiLocRibTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 10: Number of routes in per-AFI/SAFI Loc-RIB. The value is
     *         structured as: AFI (2 bytes), SAFI (1 byte), followed by a 64-bit Gauge.
     *     </code>
     * </pre>
     *
     * @return {@code PerAfiSafiLocRibTlv} perAfiSafiLocRibTlv, or {@code null} if it is not present.
     *
     */
    PerAfiSafiLocRibTlv getPerAfiSafiLocRibTlv();
    
    /**
     * Return updatesTreatedAsWithdrawTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 11: (32-bit Counter) Number of updates subjected to
     *         treat-as-withdraw treatment. 
     *     </code>
     * </pre>
     *
     * @return {@code UpdatesTreatedAsWithdrawTlv} updatesTreatedAsWithdrawTlv, or {@code null} if it is not present.
     *
     */
    UpdatesTreatedAsWithdrawTlv getUpdatesTreatedAsWithdrawTlv();
    
    /**
     * Return prefixesTreatedAsWithdrawTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 12: (32-bit Counter) Number of prefixes subjected to
     *         treat-as-withdraw treatment. 
     *     </code>
     * </pre>
     *
     * @return {@code PrefixesTreatedAsWithdrawTlv} prefixesTreatedAsWithdrawTlv, or {@code null} if it is not present.
     *
     */
    PrefixesTreatedAsWithdrawTlv getPrefixesTreatedAsWithdrawTlv();
    
    /**
     * Return duplicateUpdatesTlv, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stat Type = 13: (32-bit Counter) Number of duplicate update messages received. 
     *     </code>
     * </pre>
     *
     * @return {@code DuplicateUpdatesTlv} duplicateUpdatesTlv, or {@code null} if it is not present.
     *
     */
    DuplicateUpdatesTlv getDuplicateUpdatesTlv();

}

