package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.termination.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TerminationMessageBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TerminationMessageBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TerminationMessageBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TerminationMessageBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TerminationMessageBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class TerminationMessageBuilder implements Builder<TerminationMessage> {

    private Tlvs _tlvs;


    Map<Class<? extends Augmentation<TerminationMessage>>, Augmentation<TerminationMessage>> augmentation = Collections.emptyMap();

    public TerminationMessageBuilder() {
    }
    
    
    
    
    public TerminationMessageBuilder(Termination arg) {
        this._tlvs = arg.getTlvs();
    }

    public TerminationMessageBuilder(TerminationMessage base) {
        Map<Class<? extends Augmentation<TerminationMessage>>, Augmentation<TerminationMessage>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._tlvs = base.getTlvs();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Termination</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Termination) {
            this._tlvs = ((Termination)arg).getTlvs();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Termination]");
    }

    public Tlvs getTlvs() {
        return _tlvs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<TerminationMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public TerminationMessageBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TerminationMessageBuilder addAugmentation(Augmentation<TerminationMessage> augmentation) {
        Class<? extends Augmentation<TerminationMessage>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TerminationMessageBuilder removeAugmentation(Class<? extends Augmentation<TerminationMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public TerminationMessage build() {
        return new TerminationMessageImpl(this);
    }

    private static final class TerminationMessageImpl
        extends AbstractAugmentable<TerminationMessage>
        implements TerminationMessage {
    
        private final Tlvs _tlvs;
    
        TerminationMessageImpl(TerminationMessageBuilder base) {
            super(base.augmentation);
            this._tlvs = base.getTlvs();
        }
    
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TerminationMessage.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TerminationMessage.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TerminationMessage.bindingToString(this);
        }
    }
}
