package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The time when the encapsulated routes were received (one may also think of this 
 * as the time when they were installed in the Adj-RIB-In), expressed in seconds 
 * and microseconds since midnight (zero hour), January 1, 1970 (UTC). If zero, 
 * time is unavailable. Precision of the timestamp is implementation- dependent.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * grouping timestamp {
 *   leaf timestamp-sec {
 *     type yang:timestamp;
 *     default 0;
 *   }
 *   leaf timestamp-micro {
 *     type yang:timestamp;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/timestamp</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface Timestamp
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("timestamp");

    @Override
    Class<? extends Timestamp> implementedInterface();
    
    /**
     * Return timestampSec, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Timestamp with seconds precision.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp} timestampSec, or {@code null} if it is not present.
     *
     */
    org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp getTimestampSec();
    
    /**
     * Return timestampSec, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Timestamp with seconds precision.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp} timestampSec, guaranteed to be non-null.
     * @throws NoSuchElementException if timestampSec is not present
     *
     */
    default org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.@NonNull Timestamp requireTimestampSec() {
        return CodeHelpers.require(getTimestampSec(), "timestampsec");
    }
    
    /**
     * Return timestampMicro, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Timestamp with microseconds precision.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp} timestampMicro, or {@code null} if it is not present.
     *
     */
    org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp getTimestampMicro();
    
    /**
     * Return timestampMicro, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Timestamp with microseconds precision.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp} timestampMicro, guaranteed to be non-null.
     * @throws NoSuchElementException if timestampMicro is not present
     *
     */
    default org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.@NonNull Timestamp requireTimestampMicro() {
        return CodeHelpers.require(getTimestampMicro(), "timestampmicro");
    }

}

