package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.initiation;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.InitiationTlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StringInformations;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.description.tlv.DescriptionTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.name.tlv.NameTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.string.informations.StringInformation;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TlvsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TlvsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TlvsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TlvsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TlvsBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class TlvsBuilder implements Builder<Tlvs> {

    private DescriptionTlv _descriptionTlv;
    private NameTlv _nameTlv;
    private List<StringInformation> _stringInformation;


    Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Collections.emptyMap();

    public TlvsBuilder() {
    }
    
    
    
    public TlvsBuilder(InitiationTlvs arg) {
        this._stringInformation = arg.getStringInformation();
        this._descriptionTlv = arg.getDescriptionTlv();
        this._nameTlv = arg.getNameTlv();
    }
    public TlvsBuilder(StringInformations arg) {
        this._stringInformation = arg.getStringInformation();
    }
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv arg) {
        this._descriptionTlv = arg.getDescriptionTlv();
    }
    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv arg) {
        this._nameTlv = arg.getNameTlv();
    }

    public TlvsBuilder(Tlvs base) {
        Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._descriptionTlv = base.getDescriptionTlv();
        this._nameTlv = base.getNameTlv();
        this._stringInformation = base.getStringInformation();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv</li>
     * <li>StringInformations</li>
     * <li>InitiationTlvs</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv) {
            this._nameTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv)arg).getNameTlv();
            isValidArg = true;
        }
        if (arg instanceof StringInformations) {
            this._stringInformation = ((StringInformations)arg).getStringInformation();
            isValidArg = true;
        }
        if (arg instanceof InitiationTlvs) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv) {
            this._descriptionTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv)arg).getDescriptionTlv();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.NameTlv, StringInformations, InitiationTlvs, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.DescriptionTlv]");
    }

    public DescriptionTlv getDescriptionTlv() {
        return _descriptionTlv;
    }
    
    public NameTlv getNameTlv() {
        return _nameTlv;
    }
    
    public List<StringInformation> getStringInformation() {
        return _stringInformation;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Tlvs>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public TlvsBuilder setDescriptionTlv(final DescriptionTlv value) {
        this._descriptionTlv = value;
        return this;
    }
    
    public TlvsBuilder setNameTlv(final NameTlv value) {
        this._nameTlv = value;
        return this;
    }
    public TlvsBuilder setStringInformation(final List<StringInformation> values) {
        this._stringInformation = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TlvsBuilder addAugmentation(Augmentation<Tlvs> augmentation) {
        Class<? extends Augmentation<Tlvs>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TlvsBuilder removeAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Tlvs build() {
        return new TlvsImpl(this);
    }

    private static final class TlvsImpl
        extends AbstractAugmentable<Tlvs>
        implements Tlvs {
    
        private final DescriptionTlv _descriptionTlv;
        private final NameTlv _nameTlv;
        private final List<StringInformation> _stringInformation;
    
        TlvsImpl(TlvsBuilder base) {
            super(base.augmentation);
            this._descriptionTlv = base.getDescriptionTlv();
            this._nameTlv = base.getNameTlv();
            this._stringInformation = CodeHelpers.emptyToNull(base.getStringInformation());
        }
    
        @Override
        public DescriptionTlv getDescriptionTlv() {
            return _descriptionTlv;
        }
        
        @Override
        public NameTlv getNameTlv() {
            return _nameTlv;
        }
        
        @Override
        public List<StringInformation> getStringInformation() {
            return _stringInformation;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Tlvs.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Tlvs.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Tlvs.bindingToString(this);
        }
    }
}
