package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.MirrorPduTlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container pdu-open-tlv {
 *   uses tlv;
 *   uses bgp-msg:open-message;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/mirror-pdu-tlvs/pdu-open-tlv</i>
 *
 * <p>To create instances of this class use {@link PduOpenTlvBuilder}.
 * @see PduOpenTlvBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PduOpenTlv
    extends
    ChildOf<MirrorPduTlvs>,
    Augmentable<PduOpenTlv>,
    Tlv,
    OpenMessage
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("pdu-open-tlv");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.PduOpenTlv> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.PduOpenTlv.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.@NonNull PduOpenTlv obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBgpIdentifier());
        result = prime * result + Objects.hashCode(obj.getBgpParameters());
        result = prime * result + Objects.hashCode(obj.getHoldTimer());
        result = prime * result + Objects.hashCode(obj.getMyAsNumber());
        result = prime * result + Objects.hashCode(obj.getVersion());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.@NonNull PduOpenTlv thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.PduOpenTlv other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.PduOpenTlv.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getHoldTimer(), other.getHoldTimer())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMyAsNumber(), other.getMyAsNumber())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVersion(), other.getVersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getBgpIdentifier(), other.getBgpIdentifier())) {
            return false;
        }
        if (!Objects.equals(thisObj.getBgpParameters(), other.getBgpParameters())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs.@NonNull PduOpenTlv obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PduOpenTlv");
        CodeHelpers.appendValue(helper, "bgpIdentifier", obj.getBgpIdentifier());
        CodeHelpers.appendValue(helper, "bgpParameters", obj.getBgpParameters());
        CodeHelpers.appendValue(helper, "holdTimer", obj.getHoldTimer());
        CodeHelpers.appendValue(helper, "myAsNumber", obj.getMyAsNumber());
        CodeHelpers.appendValue(helper, "version", obj.getVersion());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }

}

