package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.mirror.pdu.tlvs;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.UpdateMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.WithdrawnRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Tlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PduUpdateTlvBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PduUpdateTlvBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PduUpdateTlvBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PduUpdateTlvBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PduUpdateTlvBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PduUpdateTlvBuilder implements Builder<PduUpdateTlv> {

    private Attributes _attributes;
    private List<Nlri> _nlri;
    private List<WithdrawnRoutes> _withdrawnRoutes;


    Map<Class<? extends Augmentation<PduUpdateTlv>>, Augmentation<PduUpdateTlv>> augmentation = Collections.emptyMap();

    public PduUpdateTlvBuilder() {
    }
    
    
    
    public PduUpdateTlvBuilder(Tlv arg) {
    }
    
    public PduUpdateTlvBuilder(UpdateMessage arg) {
        this._withdrawnRoutes = arg.getWithdrawnRoutes();
        this._nlri = arg.getNlri();
        this._attributes = arg.getAttributes();
    }
    public PduUpdateTlvBuilder(PathAttributes arg) {
        this._attributes = arg.getAttributes();
    }

    public PduUpdateTlvBuilder(PduUpdateTlv base) {
        Map<Class<? extends Augmentation<PduUpdateTlv>>, Augmentation<PduUpdateTlv>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._attributes = base.getAttributes();
        this._nlri = base.getNlri();
        this._withdrawnRoutes = base.getWithdrawnRoutes();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>UpdateMessage</li>
     * <li>PathAttributes</li>
     * <li>Tlv</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof UpdateMessage) {
            this._withdrawnRoutes = ((UpdateMessage)arg).getWithdrawnRoutes();
            this._nlri = ((UpdateMessage)arg).getNlri();
            isValidArg = true;
        }
        if (arg instanceof PathAttributes) {
            this._attributes = ((PathAttributes)arg).getAttributes();
            isValidArg = true;
        }
        if (arg instanceof Tlv) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[UpdateMessage, PathAttributes, Tlv]");
    }

    public Attributes getAttributes() {
        return _attributes;
    }
    
    public List<Nlri> getNlri() {
        return _nlri;
    }
    
    public List<WithdrawnRoutes> getWithdrawnRoutes() {
        return _withdrawnRoutes;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PduUpdateTlv>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PduUpdateTlvBuilder setAttributes(final Attributes value) {
        this._attributes = value;
        return this;
    }
    public PduUpdateTlvBuilder setNlri(final List<Nlri> values) {
        this._nlri = values;
        return this;
    }
    
    public PduUpdateTlvBuilder setWithdrawnRoutes(final List<WithdrawnRoutes> values) {
        this._withdrawnRoutes = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PduUpdateTlvBuilder addAugmentation(Augmentation<PduUpdateTlv> augmentation) {
        Class<? extends Augmentation<PduUpdateTlv>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PduUpdateTlvBuilder removeAugmentation(Class<? extends Augmentation<PduUpdateTlv>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PduUpdateTlv build() {
        return new PduUpdateTlvImpl(this);
    }

    private static final class PduUpdateTlvImpl
        extends AbstractAugmentable<PduUpdateTlv>
        implements PduUpdateTlv {
    
        private final Attributes _attributes;
        private final List<Nlri> _nlri;
        private final List<WithdrawnRoutes> _withdrawnRoutes;
    
        PduUpdateTlvImpl(PduUpdateTlvBuilder base) {
            super(base.augmentation);
            this._attributes = base.getAttributes();
            this._nlri = CodeHelpers.emptyToNull(base.getNlri());
            this._withdrawnRoutes = CodeHelpers.emptyToNull(base.getWithdrawnRoutes());
        }
    
        @Override
        public Attributes getAttributes() {
            return _attributes;
        }
        
        @Override
        public List<Nlri> getNlri() {
            return _nlri;
        }
        
        @Override
        public List<WithdrawnRoutes> getWithdrawnRoutes() {
            return _withdrawnRoutes;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PduUpdateTlv.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PduUpdateTlv.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PduUpdateTlv.bindingToString(this);
        }
    }
}
