package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerDown;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * BGP PDU containing the BGP NOTIFICATION message as received from the peer.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container notification {
 *   uses bgp-msg:notify-message;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-down/data/notification/notification</i>
 *
 * <p>To create instances of this class use {@link NotificationBuilder}.
 * @see NotificationBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Notification
    extends
    ChildOf<PeerDown>,
    Augmentable<Notification>,
    NotifyMessage
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("notification");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.Notification> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.Notification.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.@NonNull Notification obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(obj.getData());
        result = prime * result + Objects.hashCode(obj.getErrorCode());
        result = prime * result + Objects.hashCode(obj.getErrorSubcode());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.@NonNull Notification thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.Notification other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.Notification.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getErrorCode(), other.getErrorCode())) {
            return false;
        }
        if (!Objects.equals(thisObj.getErrorSubcode(), other.getErrorSubcode())) {
            return false;
        }
        if (!Arrays.equals(thisObj.getData(), other.getData())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.down.data.notification.@NonNull Notification obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Notification");
        CodeHelpers.appendValue(helper, "data", obj.getData());
        CodeHelpers.appendValue(helper, "errorCode", obj.getErrorCode());
        CodeHelpers.appendValue(helper, "errorSubcode", obj.getErrorSubcode());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }

}

