package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.AdjRibInType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container peer-header {
 *   uses peer;
 *   uses timestamp;
 *   leaf adj-rib-in-type {
 *     type adj-rib-in-type;
 *   }
 *   leaf ipv4 {
 *     type boolean;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/peer-header/peer-header</i>
 *
 * <p>To create instances of this class use {@link PeerHeaderBuilder}.
 * @see PeerHeaderBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PeerHeader
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerHeader>,
    Augmentable<PeerHeader>,
    Peer,
    Timestamp
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("peer-header");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.@NonNull PeerHeader obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAddress());
        result = prime * result + Objects.hashCode(obj.getAdjRibInType());
        result = prime * result + Objects.hashCode(obj.getAs());
        result = prime * result + Objects.hashCode(obj.getBgpId());
        result = prime * result + Objects.hashCode(obj.getIpv4());
        result = prime * result + Objects.hashCode(obj.getPeerDistinguisher());
        result = prime * result + Objects.hashCode(obj.getTimestampMicro());
        result = prime * result + Objects.hashCode(obj.getTimestampSec());
        result = prime * result + Objects.hashCode(obj.getType());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.@NonNull PeerHeader thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.PeerHeader.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAs(), other.getAs())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIpv4(), other.getIpv4())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimestampMicro(), other.getTimestampMicro())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimestampSec(), other.getTimestampSec())) {
            return false;
        }
        if (!Objects.equals(thisObj.getBgpId(), other.getBgpId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAddress(), other.getAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAdjRibInType(), other.getAdjRibInType())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPeerDistinguisher(), other.getPeerDistinguisher())) {
            return false;
        }
        if (!Objects.equals(thisObj.getType(), other.getType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header.@NonNull PeerHeader obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PeerHeader");
        CodeHelpers.appendValue(helper, "address", obj.getAddress());
        CodeHelpers.appendValue(helper, "adjRibInType", obj.getAdjRibInType());
        CodeHelpers.appendValue(helper, "as", obj.getAs());
        CodeHelpers.appendValue(helper, "bgpId", obj.getBgpId());
        CodeHelpers.appendValue(helper, "ipv4", obj.getIpv4());
        CodeHelpers.appendValue(helper, "peerDistinguisher", obj.getPeerDistinguisher());
        CodeHelpers.appendValue(helper, "timestampMicro", obj.getTimestampMicro());
        CodeHelpers.appendValue(helper, "timestampSec", obj.getTimestampSec());
        CodeHelpers.appendValue(helper, "type", obj.getType());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return adjRibInType, or {@code null} if it is not present.
     *
     * @return {@code AdjRibInType} adjRibInType, or {@code null} if it is not present.
     *
     */
    AdjRibInType getAdjRibInType();
    
    /**
     * Return adjRibInType, guaranteed to be non-null.
     *
     * @return {@code AdjRibInType} adjRibInType, guaranteed to be non-null.
     * @throws NoSuchElementException if adjRibInType is not present
     *
     */
    default @NonNull AdjRibInType requireAdjRibInType() {
        return CodeHelpers.require(getAdjRibInType(), "adjribintype");
    }
    
    /**
     * Return ipv4, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indicates if peer's address is IPv4. If set to false address is IPv6.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} ipv4, or {@code null} if it is not present.
     *
     */
    Boolean getIpv4();
    
    /**
     * Return ipv4, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Indicates if peer's address is IPv4. If set to false address is IPv6.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} ipv4, guaranteed to be non-null.
     * @throws NoSuchElementException if ipv4 is not present
     *
     */
    default @NonNull Boolean requireIpv4() {
        return CodeHelpers.require(getIpv4(), "ipv4");
    }

}

