package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.peer.header;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Timestamp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.AdjRibInType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.PeerType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PeerHeaderBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PeerHeaderBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PeerHeaderBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PeerHeaderBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PeerHeaderBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PeerHeaderBuilder implements Builder<PeerHeader> {

    private IpAddressNoZone _address;
    private AdjRibInType _adjRibInType;
    private AsNumber _as;
    private Ipv4AddressNoZone _bgpId;
    private Boolean _ipv4;
    private PeerDistinguisher _peerDistinguisher;
    private Timestamp _timestampMicro;
    private Timestamp _timestampSec;
    private PeerType _type;


    Map<Class<? extends Augmentation<PeerHeader>>, Augmentation<PeerHeader>> augmentation = Collections.emptyMap();

    public PeerHeaderBuilder() {
    }
    
    
    
    public PeerHeaderBuilder(Peer arg) {
        this._type = arg.getType();
        this._peerDistinguisher = arg.getPeerDistinguisher();
        this._address = arg.getAddress();
        this._as = arg.getAs();
        this._bgpId = arg.getBgpId();
    }
    
    public PeerHeaderBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp arg) {
        this._timestampSec = arg.getTimestampSec();
        this._timestampMicro = arg.getTimestampMicro();
    }

    public PeerHeaderBuilder(PeerHeader base) {
        Map<Class<? extends Augmentation<PeerHeader>>, Augmentation<PeerHeader>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._address = base.getAddress();
        this._adjRibInType = base.getAdjRibInType();
        this._as = base.getAs();
        this._bgpId = base.getBgpId();
        this._ipv4 = base.getIpv4();
        this._peerDistinguisher = base.getPeerDistinguisher();
        this._timestampMicro = base.getTimestampMicro();
        this._timestampSec = base.getTimestampSec();
        this._type = base.getType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Peer</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Peer) {
            this._type = ((Peer)arg).getType();
            this._peerDistinguisher = ((Peer)arg).getPeerDistinguisher();
            this._address = ((Peer)arg).getAddress();
            this._as = ((Peer)arg).getAs();
            this._bgpId = ((Peer)arg).getBgpId();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp) {
            this._timestampSec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampSec();
            this._timestampMicro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp)arg).getTimestampMicro();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Peer, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Timestamp]");
    }

    public IpAddressNoZone getAddress() {
        return _address;
    }
    
    public AdjRibInType getAdjRibInType() {
        return _adjRibInType;
    }
    
    public AsNumber getAs() {
        return _as;
    }
    
    public Ipv4AddressNoZone getBgpId() {
        return _bgpId;
    }
    
    public Boolean getIpv4() {
        return _ipv4;
    }
    
    public PeerDistinguisher getPeerDistinguisher() {
        return _peerDistinguisher;
    }
    
    public Timestamp getTimestampMicro() {
        return _timestampMicro;
    }
    
    public Timestamp getTimestampSec() {
        return _timestampSec;
    }
    
    public PeerType getType() {
        return _type;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PeerHeader>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PeerHeaderBuilder setAddress(final IpAddressNoZone value) {
        this._address = value;
        return this;
    }
    
    public PeerHeaderBuilder setAdjRibInType(final AdjRibInType value) {
        this._adjRibInType = value;
        return this;
    }
    
    public PeerHeaderBuilder setAs(final AsNumber value) {
        this._as = value;
        return this;
    }
    
    public PeerHeaderBuilder setBgpId(final Ipv4AddressNoZone value) {
        this._bgpId = value;
        return this;
    }
    
    public PeerHeaderBuilder setIpv4(final Boolean value) {
        this._ipv4 = value;
        return this;
    }
    
    public PeerHeaderBuilder setPeerDistinguisher(final PeerDistinguisher value) {
        this._peerDistinguisher = value;
        return this;
    }
    
    public PeerHeaderBuilder setTimestampMicro(final Timestamp value) {
        this._timestampMicro = value;
        return this;
    }
    
    public PeerHeaderBuilder setTimestampSec(final Timestamp value) {
        this._timestampSec = value;
        return this;
    }
    
    public PeerHeaderBuilder setType(final PeerType value) {
        this._type = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PeerHeaderBuilder addAugmentation(Augmentation<PeerHeader> augmentation) {
        Class<? extends Augmentation<PeerHeader>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PeerHeaderBuilder removeAugmentation(Class<? extends Augmentation<PeerHeader>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PeerHeader build() {
        return new PeerHeaderImpl(this);
    }

    private static final class PeerHeaderImpl
        extends AbstractAugmentable<PeerHeader>
        implements PeerHeader {
    
        private final IpAddressNoZone _address;
        private final AdjRibInType _adjRibInType;
        private final AsNumber _as;
        private final Ipv4AddressNoZone _bgpId;
        private final Boolean _ipv4;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher _peerDistinguisher;
        private final Timestamp _timestampMicro;
        private final Timestamp _timestampSec;
        private final PeerType _type;
    
        PeerHeaderImpl(PeerHeaderBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._adjRibInType = base.getAdjRibInType();
            this._as = base.getAs();
            this._bgpId = base.getBgpId();
            this._ipv4 = base.getIpv4();
            this._peerDistinguisher = base.getPeerDistinguisher();
            this._timestampMicro = base.getTimestampMicro();
            this._timestampSec = base.getTimestampSec();
            this._type = base.getType();
        }
    
        @Override
        public IpAddressNoZone getAddress() {
            return _address;
        }
        
        @Override
        public AdjRibInType getAdjRibInType() {
            return _adjRibInType;
        }
        
        @Override
        public AsNumber getAs() {
            return _as;
        }
        
        @Override
        public Ipv4AddressNoZone getBgpId() {
            return _bgpId;
        }
        
        @Override
        public Boolean getIpv4() {
            return _ipv4;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Peer.PeerDistinguisher getPeerDistinguisher() {
            return _peerDistinguisher;
        }
        
        @Override
        public Timestamp getTimestampMicro() {
            return _timestampMicro;
        }
        
        @Override
        public Timestamp getTimestampSec() {
            return _timestampSec;
        }
        
        @Override
        public PeerType getType() {
            return _type;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PeerHeader.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PeerHeader.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PeerHeader.bindingToString(this);
        }
    }
}
