package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.Stat;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.StatTlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bmp-message</b>
 * <pre>
 * container tlvs {
 *   uses stat-tlvs;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bmp-message/stat/tlvs</i>
 *
 * <p>To create instances of this class use {@link TlvsBuilder}.
 * @see TlvsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Tlvs
    extends
    ChildOf<Stat>,
    Augmentable<Tlvs>,
    StatTlvs
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tlvs");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.Tlvs> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.Tlvs.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.@NonNull Tlvs obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAdjRibsInRoutesTlv());
        result = prime * result + Objects.hashCode(obj.getDuplicatePrefixAdvertisementsTlv());
        result = prime * result + Objects.hashCode(obj.getDuplicateUpdatesTlv());
        result = prime * result + Objects.hashCode(obj.getDuplicateWithdrawsTlv());
        result = prime * result + Objects.hashCode(obj.getInvalidatedAsConfedLoopTlv());
        result = prime * result + Objects.hashCode(obj.getInvalidatedAsPathLoopTlv());
        result = prime * result + Objects.hashCode(obj.getInvalidatedClusterListLoopTlv());
        result = prime * result + Objects.hashCode(obj.getInvalidatedOriginatorIdTlv());
        result = prime * result + Objects.hashCode(obj.getLocRibRoutesTlv());
        result = prime * result + Objects.hashCode(obj.getPerAfiSafiAdjRibInTlv());
        result = prime * result + Objects.hashCode(obj.getPerAfiSafiLocRibTlv());
        result = prime * result + Objects.hashCode(obj.getPrefixesTreatedAsWithdrawTlv());
        result = prime * result + Objects.hashCode(obj.getRejectedPrefixesTlv());
        result = prime * result + Objects.hashCode(obj.getUpdatesTreatedAsWithdrawTlv());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.@NonNull Tlvs thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.Tlvs other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.Tlvs.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAdjRibsInRoutesTlv(), other.getAdjRibsInRoutesTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDuplicatePrefixAdvertisementsTlv(), other.getDuplicatePrefixAdvertisementsTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDuplicateUpdatesTlv(), other.getDuplicateUpdatesTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDuplicateWithdrawsTlv(), other.getDuplicateWithdrawsTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInvalidatedAsConfedLoopTlv(), other.getInvalidatedAsConfedLoopTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInvalidatedAsPathLoopTlv(), other.getInvalidatedAsPathLoopTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInvalidatedClusterListLoopTlv(), other.getInvalidatedClusterListLoopTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInvalidatedOriginatorIdTlv(), other.getInvalidatedOriginatorIdTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLocRibRoutesTlv(), other.getLocRibRoutesTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPerAfiSafiAdjRibInTlv(), other.getPerAfiSafiAdjRibInTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPerAfiSafiLocRibTlv(), other.getPerAfiSafiLocRibTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPrefixesTreatedAsWithdrawTlv(), other.getPrefixesTreatedAsWithdrawTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRejectedPrefixesTlv(), other.getRejectedPrefixesTlv())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUpdatesTreatedAsWithdrawTlv(), other.getUpdatesTreatedAsWithdrawTlv())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev200120.stat.@NonNull Tlvs obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Tlvs");
        CodeHelpers.appendValue(helper, "adjRibsInRoutesTlv", obj.getAdjRibsInRoutesTlv());
        CodeHelpers.appendValue(helper, "duplicatePrefixAdvertisementsTlv", obj.getDuplicatePrefixAdvertisementsTlv());
        CodeHelpers.appendValue(helper, "duplicateUpdatesTlv", obj.getDuplicateUpdatesTlv());
        CodeHelpers.appendValue(helper, "duplicateWithdrawsTlv", obj.getDuplicateWithdrawsTlv());
        CodeHelpers.appendValue(helper, "invalidatedAsConfedLoopTlv", obj.getInvalidatedAsConfedLoopTlv());
        CodeHelpers.appendValue(helper, "invalidatedAsPathLoopTlv", obj.getInvalidatedAsPathLoopTlv());
        CodeHelpers.appendValue(helper, "invalidatedClusterListLoopTlv", obj.getInvalidatedClusterListLoopTlv());
        CodeHelpers.appendValue(helper, "invalidatedOriginatorIdTlv", obj.getInvalidatedOriginatorIdTlv());
        CodeHelpers.appendValue(helper, "locRibRoutesTlv", obj.getLocRibRoutesTlv());
        CodeHelpers.appendValue(helper, "perAfiSafiAdjRibInTlv", obj.getPerAfiSafiAdjRibInTlv());
        CodeHelpers.appendValue(helper, "perAfiSafiLocRibTlv", obj.getPerAfiSafiLocRibTlv());
        CodeHelpers.appendValue(helper, "prefixesTreatedAsWithdrawTlv", obj.getPrefixesTreatedAsWithdrawTlv());
        CodeHelpers.appendValue(helper, "rejectedPrefixesTlv", obj.getRejectedPrefixesTlv());
        CodeHelpers.appendValue(helper, "updatesTreatedAsWithdrawTlv", obj.getUpdatesTreatedAsWithdrawTlv());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }

}

